package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.em.*;
import com.jhscale.meter.utils.ByteUtils;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

/**
 * @author lie_w
 * @title: StringPara
 * @projectName jhscale-agreement
 * @description: 3.3.2 绘制字符串
 * @date 2020-12-2414:31
 */
public class StringPara<T extends StringPara> extends Para {

    public StringPara() {
        super.setType(ParaType.String);
    }

    public StringPara(String content, Dir dir, Grid grid, Font font, Integer start_x, Integer start_y, Integer offset_x, Integer offset_y, StrPara... strParas) {
        this(content, start_x, start_y, offset_x, offset_y);
        this.dir = dir;
        this.paras = Arrays.asList(strParas);
        this.grid = grid;
        this.font = font;
    }

    public StringPara(String content, Integer start_x, Integer start_y, Integer offset_x, Integer offset_y) {
        this();
        this.content = content;
        this.start_x = start_x;
        this.start_y = start_y;
        this.offset_x = offset_x;
        this.offset_y = offset_y;
    }

    // 方向 0°90°180°270°
    private Dir dir = Dir.ZERO;

    // 标志
    private List<StrPara> paras;

    // 对齐方式
    private Grid grid = Grid.Defaul_Grid;

    // 字体
    private Font font = Font.FONT4;

    private Integer start_x;

    private Integer start_y;

    private Integer offset_x;

    private Integer offset_y;

    private String content;

    /**
     * @description: 设置方向
     **/
    public T set_Dir(Dir dir) throws MeterException {
        this.dir = dir;
        return (T) this;
    }

    /**
     * @description: 添加标志
     **/
    public T addParas(StrPara... paras) {
        if (paras != null && paras.length > 0) {
            if (this.paras == null) {
                this.paras = Arrays.asList(paras);
            } else {
                this.paras.addAll(Arrays.asList(paras));
            }
        }
        return (T) this;
    }

    /**
     * @description: 设置标志
     **/
    public T set_Paras(StrPara... paras) {
        if (paras != null && paras.length > 0)
            this.paras = Arrays.asList(paras);
        return (T) this;
    }

    /**
     * @description: 设置对齐方式
     **/
    public T set_Grid(Grid grid) throws MeterException {
        this.grid = grid;
        return (T) this;
    }

    /**
     * @description: 设置字体
     **/
    public T set_Font(Font font) {
        this.font = font;
        return (T) this;
    }

    public T setStartX(Integer start_x) throws MeterException {
        this.start_x = start_x;
        return (T) this;
    }

    public T setStartY(Integer start_y) throws MeterException {
        this.start_y = start_y;
        return (T) this;
    }

    public T setOffsetX(Integer offset_x) throws MeterException {
        this.offset_x = offset_x;
        return (T) this;
    }

    public T setOffsetY(Integer offset_y) throws MeterException {
        this.offset_y = offset_y;
        return (T) this;
    }

    public T set_Content(String content) {
        this.content = content;
        return (T) this;
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset)
                .append(this.dir.getHexVal())
                .append(this.compileStrPara(this.paras))
                .append(this.grid.getHexVal())
                .append(this.font.getHexVal())
                .append(to2ByteHex(this.start_x))
                .append(to2ByteHex(this.start_y))
                .append(to2ByteHex(this.offset_x))
                .append(to2ByteHex(this.offset_y))
                .append(ByteUtils.toHexString(this.content.getBytes(charset)) + "00");
    }

    public Dir getDir() {
        return dir;
    }

    public void setDir(Dir dir) throws MeterException {
        this.dir = dir;
    }

    public List<StrPara> getParas() {
        return paras;
    }

    public void setParas(List<StrPara> paras) {
        this.paras = paras;
    }

    public Grid getGrid() {
        return grid;
    }

    public void setGrid(Grid grid) throws MeterException {
        this.grid = grid;
    }

    public Font getFont() {
        return font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Integer getStart_x() {
        return start_x;
    }

    public void setStart_x(Integer start_x) throws MeterException {
        this.start_x = start_x;
    }

    public Integer getStart_y() {
        return start_y;
    }

    public void setStart_y(Integer start_y) throws MeterException {
        this.start_y = start_y;
    }

    public Integer getOffset_x() {
        return offset_x;
    }

    public void setOffset_x(Integer offset_x) throws MeterException {
        this.offset_x = offset_x;
    }

    public Integer getOffset_y() {
        return offset_y;
    }

    public void setOffset_y(Integer offset_y) throws MeterException {
        this.offset_y = offset_y;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) throws MeterException {
        this.content = content;
    }
}
