package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.em.DotImage;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ColorRatioBuilder
 * @projectName jhscale-agreement
 * @description: 颜色百分比点图
 * @date 2021/3/2923:25
 */
public class ColorRatioBuilder extends DotplotBuilder<ColorRatioBuilder> {

    // 点图百分比
    private Double ratio = ImageConstant.DEFAULT_RATIO;

    public ColorRatioBuilder() {
        super.setDotImage(DotImage.Color);
    }

    /**
     * @description: 添加颜色百分比
     **/
    public ColorRatioBuilder addRatio(Double ratio) {
        if (Objects.nonNull(ratio))
            this.ratio = ratio;
        return this;
    }

    @Override
    protected ColorRatioBuilder check() throws MeterException {
        if (Objects.isNull(this.ratio))
            throw new MeterException(MeterStateEnum.Color临界点百分比不存在);
        return super.check();
    }

    /**
     * @description: 添加点图值信息
     **/
    @Override
    protected DitherVal ditherVal() {
        DitherVal ditherVal = new DitherVal();
        ImageBuffer targetBuffer = super.getTargetBuffer();
        ditherVal.setX(targetBuffer.getMinX());
        ditherVal.setY(targetBuffer.getMinY());
        ditherVal.setWidth(targetBuffer.getWidth());
        ditherVal.setHeight(targetBuffer.getHeight());
        int[] data = new int[targetBuffer.getHeight() * targetBuffer.getWidth()];
        ditherVal.setData(data);

        int divide = (int) (-16777215 * this.ratio);
        int index = 0;
        // RGB色素处理
        for (int j = 0; j < targetBuffer.getRgbs().length; j++) {
            for (int i = 0; i < targetBuffer.getRgbs()[j].length; i++) {
                data[index] = targetBuffer.getRgbs()[j][i].getPixel() < divide ? 1 : 0;
                index++;
            }
        }
        return ditherVal;
    }

    @Override
    protected ImageBuffer construct() {
        return super.getSourceBuffer().copy();
    }
}
