package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.protocol.print.dither.ImageBuffer;

/**
 * @author lie_w
 * @title: CompressBulider
 * @projectName jhscale-agreement
 * @description: 缩放 构建者
 * @date 2021/3/2920:01
 */
public class CompressBuilder<T extends CompressBuilder> extends ImageBuilder<T> {

    // 宽
    private int width;
    // 高
    private int height;

    /**
     * @description: 实际构建方式
     **/
    @Override
    protected ImageBuffer construct() {
        return super.getImageProcess().compress(super.getSourceBuffer(), this.width, this.height);
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    protected void setHeight(int height) {
        this.height = height;
    }
}
