package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.em.DotImage;

import java.util.Objects;

/**
 * @author lie_w
 * @title: DitherBulider
 * @projectName jhscale-agreement
 * @description: 点图 建造者
 * @date 2021/3/2915:55
 */
public abstract class DotplotBuilder<T extends DotplotBuilder> extends ImageBuilder<T> {

    // 点图处理方式
    private DotImage dotImage;

    // Dither内容参数
    private DitherVal ditherVal;

    @Override
    protected T check() throws MeterException {
        if (Objects.isNull(dotImage))
            throw new MeterException(MeterStateEnum.点图处理方式无效);
        return super.check();
    }

    @Override
    protected T after() throws MeterException {
        this.ditherVal = ditherVal();
        return super.after();
    }

    /**
     * @description: 添加点图值信息
     **/
    protected abstract DitherVal ditherVal();

    protected void setDotImage(DotImage dotImage) {
        this.dotImage = dotImage;
    }

    /**
     * @description: 点图资源
     **/
    public DitherVal getDitherVal() {
        return ditherVal;
    }
}
