package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.protocol.print.dither.ImageBuffer;

import java.io.File;

/**
 * @author Loveven
 * @title: ImageProcess
 * @projectName jhscale-agreement
 * @description: 图片处理器
 * @date 2021-03-2614:16
 */
public interface ImageProcess {

    /**
     * @description: 读取RGB
     **/
    RGB readRGB(int pixel);

    /**
     * @description: 写RGB 红 绿 蓝 透明度
     **/
    RGB writeRGB(int red, int green, int blue, int alpha);

    /**
     * @description: 写RGB
     **/
    int writeRGB(RGB rgb);

    /**
     * @description: 读取图片文件
     **/
    ImageBuffer readImage(File file);

    /**
     * @description: 写文件
     **/
    void writeImage(ImageBuffer buffer, File target);

    /**
     * @description: 图片压缩
     **/
    ImageBuffer compress(ImageBuffer buffer, int width, int height);
}
