package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.protocol.print.dither.ImageBuffer;

/**
 * @author lie_w
 * @title: OnehundredandeightRatateBuilder
 * @projectName jhscale-agreement
 * @description: 180°
 * @date 2021/3/3012:46
 */
public class OnehundredandeightyRatateBuilder extends RotateBuilder<OnehundredandeightyRatateBuilder> {
    /**
     * @description: 实际构建方式
     **/
    @Override
    protected ImageBuffer construct() {
        ImageBuffer target = super.getSourceBuffer().copy();
        RGB[][] targetRGBS = new RGB[target.getHeight()][target.getWidth()];
        target.setRgbs(targetRGBS);
        RGB[][] sourceRGBS = super.getSourceBuffer().getRgbs();
        for (int j = 0; j < sourceRGBS.length; j++) {
            for (int i = 0; i < sourceRGBS[j].length; i++) {
                targetRGBS[sourceRGBS.length - 1 - j][sourceRGBS[j].length - 1 - i] = sourceRGBS[j][i];
            }
        }
        return target;
    }
}
