package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.exp.MeterException;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ProportionCompressBulider
 * @projectName jhscale-agreement
 * @description: 比例缩放 构建者
 * @date 2021/3/3010:09
 */
public class ProportionCompressBuilder extends CompressBuilder<ProportionCompressBuilder> {

    // 缩放比例
    private double rate = 1.0;

    /**
     * @description: 添加 缩放比例
     **/
    public ProportionCompressBuilder addRate(Double rate) {
        if (Objects.nonNull(rate))
            this.rate = rate;
        return this;
    }

    @Override
    protected ProportionCompressBuilder before() throws MeterException {
        super.before();
        super.setWidth(((int) (super.getSourceBuffer().getWidth() * this.rate)));
        super.setHeight(((int) (super.getSourceBuffer().getHeight() * this.rate)));
        return this;
    }
}
