package com.jhscale.meter.protocol.print.image;

import com.jhscale.common.model.inter.JSONModel;

/**
 * @author lie_w
 * @title: RGB
 * @projectName jhscale-agreement
 * @description: RGB
 * @date 2021/3/2617:15
 */
public class RGB implements JSONModel {

    // RGB数值
    private int pixel;

    // 透明度
    private int alpha;

    // 红色 INT
    private int RI;

    // 红色 HEX
    private String RH;

    // 绿色 INT
    private int GI;

    // 绿色 HEX
    private String GH;

    // 蓝色 INT
    private int BI;

    // 蓝色 HEX
    private String BH;

    public RGB() {
    }

    @Deprecated
    public RGB(int pixel) {
        this.pixel = pixel;
        this.RI = (pixel & 0xff0000) >> 16;
        this.RH = Integer.toHexString(this.RI);
        this.GI = (pixel & 0xff00) >> 8;
        this.GH = Integer.toHexString(this.GI);
        this.BI = pixel & 0xff;
        this.BH = Integer.toHexString(this.BI);
    }

    /**
     * @description: RGB Hex 数值
     **/
    public String RGB() {
        return this.RH + this.GH + this.BH;
    }

    public int getPixel() {
        return pixel;
    }

    public void setPixel(int pixel) {
        this.pixel = pixel;
    }

    public int getAlpha() {
        return alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getRI() {
        return RI;
    }

    public void setRI(int RI) {
        this.RI = RI;
    }

    public String getRH() {
        return RH;
    }

    public void setRH(String RH) {
        this.RH = RH;
    }

    public int getGI() {
        return GI;
    }

    public void setGI(int GI) {
        this.GI = GI;
    }

    public String getGH() {
        return GH;
    }

    public void setGH(String GH) {
        this.GH = GH;
    }

    public int getBI() {
        return BI;
    }

    public void setBI(int BI) {
        this.BI = BI;
    }

    public String getBH() {
        return BH;
    }

    public void setBH(String BH) {
        this.BH = BH;
    }
}
