package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.protocol.print.dither.ImageBuffer;

/**
 * @author lie_w
 * @title: NinetyRotateBuilder
 * @projectName jhscale-agreement
 * @description: 270°
 * @date 2021/3/3012:27
 */
public class TwohundredandseventyRatateBuilder extends RotateBuilder<TwohundredandseventyRatateBuilder> {
    /**
     * @description: 实际构建方式
     **/
    @Override
    protected ImageBuffer construct() {
        ImageBuffer target = super.getSourceBuffer().copy();
        target.setHeight(super.getSourceBuffer().getWidth());
        target.setWidth(super.getSourceBuffer().getHeight());
        target.setMinX(super.getSourceBuffer().getMinY());
        RGB[][] targetRGBS = new RGB[target.getHeight()][target.getWidth()];
        target.setRgbs(targetRGBS);
        RGB[][] sourceRGBS = super.getSourceBuffer().getRgbs();
        for (int j = 0; j < sourceRGBS.length; j++) {
            for (int i = 0; i < sourceRGBS[j].length; i++) {
                targetRGBS[sourceRGBS[j].length - 1 - i][j] = sourceRGBS[j][i];
            }
        }
        return target;
    }
}
