package com.jhscale.meter.protocol.print.line;

import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: PrintLine
 * @projectName meter-jar
 * @description: 条码模式
 * @date 2023/3/249:14
 */
public class PrintLineBC implements PrintLine {

    // 条码类型
    private String barcode;

    // 条码内容
    private String content;

    public PrintLineBC() {
    }

    public PrintLineBC(String barcode, String content) {
        this.barcode = barcode;
        this.content = content;
    }

    /**
     * @description: 有效行检查
     **/
    @Override
    public boolean valid() {
        return StringUtils.isNotBlank(this.content);
    }

    /**
     * @param request
     * @description: 添加行模式打印内容
     */
    @Override
    public PrintLine add(PrintDataRequest request) {
        if (this.valid()) {
            if (StringUtils.isNotBlank(this.barcode)) {
                request.Input_Barcode(this.content, this.barcode);
            } else {
                request.Input_QR(this.content);
            }
        }
        return this;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public PrintLineBC setBarcode(String barcode) {
        this.barcode = barcode;
        return this;
    }

    public String getContent() {
        return content;
    }

    public PrintLineBC setContent(String content) {
        this.content = content;
        return this;
    }
}
