package com.jhscale.meter.protocol.print.line;

import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;

import java.util.Objects;

/**
 * @author lie_w
 * @title: PrintLine
 * @projectName meter-jar
 * @description: 位图
 * @date 2023/3/249:14
 */
public class PrintLineBP implements PrintLine {

    private Integer bitmap;


    public PrintLineBP() {
    }

    public PrintLineBP(Integer bitmap) {
        this.bitmap = bitmap;
    }

    /**
     * @description: 有效行检查
     **/
    @Override
    public boolean valid() {
        return Objects.nonNull(this.bitmap);
    }

    /**
     * @param request
     * @description: 添加行模式打印内容
     */
    @Override
    public PrintLine add(PrintDataRequest request) {
        if (this.valid()) request.Input_Bitmap(this.bitmap);
        return this;
    }

    public Integer getBitmap() {
        return bitmap;
    }

    public PrintLineBP setBitmap(Integer bitmap) {
        this.bitmap = bitmap;
        return this;
    }
}
