package com.jhscale.meter.protocol.print.line;

import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: PrintLine
 * @projectName meter-jar
 * @description: 左中右模式
 * @date 2023/3/249:14
 */
public class PrintLineLMR implements PrintLine {

    private String left;

    private String mid;

    private String right;

    private Integer font;

    /**
     * @description: 有效行检查
     **/
    @Override
    public boolean valid() {
        return StringUtils.isNotBlank(this.left) || StringUtils.isNotBlank(this.mid) || StringUtils.isNotBlank(this.right);
    }

    /**
     * @param request
     * @description: 添加行模式打印内容
     */
    @Override
    public PrintLine add(PrintDataRequest request) {
        if (this.valid()) {
            if (Objects.isNull(this.font)) {
                request.Input_String(this.left, this.mid, this.right);
            } else {
                request.Input_String(this.left, this.mid, this.right, this.font);
            }
        }
        return this;
    }

    public String getLeft() {
        return left;
    }

    public PrintLineLMR setLeft(String left) {
        this.left = left;
        return this;
    }

    public String getMid() {
        return mid;
    }

    public PrintLineLMR setMid(String mid) {
        this.mid = mid;
        return this;
    }

    public String getRight() {
        return right;
    }

    public PrintLineLMR setRight(String right) {
        this.right = right;
        return this;
    }

    public Integer getFont() {
        return font;
    }

    public PrintLineLMR setFont(Integer font) {
        this.font = font;
        return this;
    }
}
