package com.jhscale.meter.protocol.print.line;

import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: PrintLine
 * @projectName meter-jar
 * @description: 换行模式
 * @date 2023/3/249:14
 */
public class PrintLineN implements PrintLine {

    private String content;

    // 换行
    private boolean multiLine = true;

    private Integer font;

    public PrintLineN() {
    }

    public PrintLineN(String content) {
        this.content = content;
    }

    public PrintLineN(String content, boolean multiLine) {
        this.content = content;
        this.multiLine = multiLine;
    }

    public PrintLineN(String content, Integer font) {
        this.content = content;
        this.font = font;
    }

    public PrintLineN(String content, boolean multiLine, Integer font) {
        this.content = content;
        this.multiLine = multiLine;
        this.font = font;
    }

    /**
     * @description: 分割换行符
     * @date: 2024-11-15 10:47:24
     **/
    public static PrintLineN separator(int font) {
        return new PrintLineN("--------------------------------------------", false, font);
    }

    /**
     * @description: 有效行检查
     **/
    @Override
    public boolean valid() {
        return StringUtils.isNotBlank(this.content);
    }

    /**
     * @param request
     * @description: 添加行模式打印内容
     */
    @Override
    public PrintLine add(PrintDataRequest request) {
        if (this.valid()) {
            if (Objects.isNull(this.font)) {
                request.Input_String(this.content, this.multiLine);
            } else {
                request.Input_String(this.content, this.font, this.multiLine);
            }
        }
        return this;
    }

    public String getContent() {
        return content;
    }

    public PrintLineN setContent(String content) {
        this.content = content;
        return this;
    }

    public boolean isMultiLine() {
        return multiLine;
    }

    public PrintLineN setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
        return this;
    }

    public Integer getFont() {
        return font;
    }

    public PrintLineN setFont(Integer font) {
        this.font = font;
        return this;
    }
}
