package com.jhscale.meter.protocol.print.link;

import com.alibaba.fastjson.JSON;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.SerialTool;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;

import java.util.Objects;

/**
 * @author lie_w
 * @title: PrintSerialMessenger
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-0718:29
 */
public class DefaultPrintSerialMessenger implements Messenger {

    private String portName = "COM3";
    private int baudrate = 115200;
    private SerialPort serialPort;

    private PrintRequest request;
    private PrintResponse response;

    public DefaultPrintSerialMessenger() {
    }

    public DefaultPrintSerialMessenger(String portName, int baudrate) throws MeterException {
        this.portName = portName;
        this.baudrate = baudrate;
        serialPortInit();
    }

    /**
     * @param data
     * @description: 发送数据
     */
    @Override
    public SendResult send(String data) {
        return null;
    }

    /**
     * @param communicationLogo
     * @description: 收到数据
     */
    @Override
    public ReadReuslt read(String communicationLogo) {
        return null;
    }

    /**
     * @param communicationLogo
     * @description: 通讯有效时间
     */
    @Override
    public boolean effectiveCommunicationTime(String communicationLogo) {
        return false;
    }

    /**
     * @param cmd
     * @param request
     * @param response
     * @description: 发送有效数据
     */
    @Override
    public void sendCmd(String cmd, PrintRequest request, PrintResponse response) throws Exception {
        System.out.println(String.format("通讯器[%s]发送命令：%s", request.getCommunication().getSerial(), cmd));
        if (Objects.isNull(this.serialPort)) serialPortInit();
        this.request = request;
        this.response = response;
        long start1 = System.currentTimeMillis();
        byte[] bytes = ByteUtils.fromHexString(cmd);
        long start2 = System.currentTimeMillis();
        SerialTool.sendToPort(this.serialPort, bytes);
        System.out.println("打印串口[" + request.getCommunication().getSerial() + "]发送数据 转换耗时："
                + (start2 - start1) + " 发送耗时： " + (System.currentTimeMillis() - start2) + "； 数据内容：" + cmd);
    }

    /**
     * @param bytes
     * @param request
     * @param response
     * @description: 发送字节流数据
     */
    @Override
    public void sendCmd(byte[] bytes, PrintRequest request, PrintResponse response) throws Exception {
        if (Objects.isNull(serialPort))
            serialPortInit();
        this.request = request;
        this.response = response;
        long start1 = System.currentTimeMillis();
        SerialTool.sendToPort(this.serialPort, bytes);
        System.out.println("打印串口发送数据 耗时： " + (System.currentTimeMillis() - start1) + "； 数据内容：" + JSON.toJSONString(bytes));
    }

    /**
     * @description: 关闭通讯器
     **/
    @Override
    public void close() {
        SerialTool.closePort(this.serialPort);
    }

    /**
     * @description: 通讯去编号标识
     **/
    @Override
    public String identify() {
        return this.portName;
    }

    /**
     * @description: 初始化串口通讯
     **/
    private void serialPortInit() throws MeterException {
        this.serialPort = SerialTool.openPort(portName, baudrate);
        SerialTool.addListener(this.serialPort, new SerialPortEventListener() {
            @Override
            public void serialEvent(SerialPortEvent serialPortEvent) {
                switch (serialPortEvent.getEventType()) {
                    case SerialPortEvent.BI: // 10 通讯中断
                        break;
                    case SerialPortEvent.OE: // 7 溢位（溢出）错误
                        break;
                    case SerialPortEvent.FE: // 9 帧错误
                        break;
                    case SerialPortEvent.PE: // 8 奇偶校验错误
                        break;
                    case SerialPortEvent.CD: // 6 载波检测
                        break;
                    case SerialPortEvent.CTS: // 3 清除待发送数据
                        break;
                    case SerialPortEvent.DSR: // 4 待发送数据准备好了
                        break;
                    case SerialPortEvent.RI: // 5 振铃指示
                        break;
                    case SerialPortEvent.OUTPUT_BUFFER_EMPTY: // 2 输出缓冲区已清空
                        break;
                    case SerialPortEvent.DATA_AVAILABLE: // 1 串口存在可用数据
                        try {
                            Thread.sleep(50);
                            String accept = ByteUtils.toHexAscii(SerialTool.readFromPort(serialPort));
                            System.out.println(String.format("打印串口接受数据：%s", accept));
                            response.callBack(accept, request);
                        } catch (MeterException e) {
                            e.printStackTrace();
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        break;
                }
            }
        });
    }
}
