package com.jhscale.meter.protocol.print.link;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;

/**
 * @author lie_w
 * @title: IPrintBack
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-2512:41
 */
public interface IPrintBack extends JSONModel {

    /**
     * @description: 操作结果响应业务信息
     **/
    default void responseBack(PrintBackResponse response) {
        try {
            System.out.println(response.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 操作结果响应原始信息
     **/
    default void responseBack(PrintResponse response) {
        try {
            System.out.println(response.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 过程进度
     **/
    default void schedule(ScheduleState scheduleState) {
        try {
            System.out.println(scheduleState.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
