package com.jhscale.meter.protocol.print.link;

import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;

/**
 * @author lie_w
 * @title: Messenger
 * @projectName jhscale-agreement
 * @description: 通讯器
 * @date 2020-12-229:17
 */
public interface Messenger {

    /**
     * @description: 发送数据
     **/
    @Deprecated
    default SendResult send(String data) {
        return null;
    }

    /**
     * @description: 收到数据
     **/
    @Deprecated
    default ReadReuslt read(String communicationLogo) {
        return null;
    }

    /**
     * @description: 通讯有效时间
     **/
    @Deprecated
    default boolean effectiveCommunicationTime(String communicationLogo) {
        return true;
    }

    /**
     * @description: 发送有效数据
     **/
    void sendCmd(String cmd, PrintRequest request, PrintResponse response) throws Exception;

    /**
     * @description: 发送字节流数据
     **/
    default void sendCmd(byte[] bytes, PrintRequest request, PrintResponse response) throws Exception {
    }

    /**
     * @description: 关闭通讯器
     **/
    default void close() {
    }

    /**
     * @description: 通讯去编号标识(串口通讯, 串口号)
     **/
    String identify();
}
