package com.jhscale.meter.protocol.print.link;

import com.jhscale.common.model.inter.JSONModel;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: ReadReuslt
 * @projectName jhscale-agreement
 * @description: 读取数据
 * @date 2020-12-2210:05
 */
public class ReadReuslt implements JSONModel {

    // 响应体状态 true 存在 false 不存在
    private boolean state;

    // 响应体
    private String response;

    public ReadReuslt() {
    }

    public ReadReuslt(boolean state, String response) {
        this.state = state;
        this.response = response;
    }

    /**
     * @description: 存在响应体
     **/
    public boolean hasResponse() {
        return this.state && StringUtils.isNotBlank(this.response);
    }

    public boolean isState() {
        return state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }
}
