package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.entity.PrintRequest;

import java.io.Serializable;

/**
 * @author lie_w
 * @title: IPrintBasic
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/10/2623:20
 */
public interface IPrintBasic extends Serializable {

    /**
     * @description: 获取当前通讯器
     **/
    PrintCommunication communication();

    /**
     * @description: 直接发送 Content 内容信息
     * PrintType printType 新接口取消此参数 Request对象自带
     **/
    default void send(PrintRequest request) throws MeterException {
        this.communication().sendData(request);
    }

    /**
     * @description: 发送命令操作(不需要获取内存空间)
     **/
    default void sendAll(PrintRequest request) throws MeterException {
        this.communication().sendDataWithAllPackage(request);
    }
}
