package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.em.PrintParamSave;
import com.jhscale.meter.protocol.print.entity.cmd.*;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.EntityCard;
import com.jhscale.meter.protocol.print.produce.entity.PrintSetRequest;

/**
 * @author lie_w
 * @title: IPrintCmd
 * @projectName jhscale-agreement
 * @description: 打印命令
 * @date 2021-01-118:32
 */
public interface IPrintCmd extends IPrintBasic {

    /**
     * @description: 发送命令操作
     **/
    default void cmdSend(PrintCmdRequest request) throws MeterException {
        this.send(request);
    }

    /**
     * @description: 获取打印机信息
     **/
    default void getPrintInfo(IPrintBack printBack) throws MeterException {
        Print0000Request request = new Print0000Request();
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    /**
     * @description: 获取打印机信息(不获取缓冲)
     **/
    // default void getPrintInfo2(IPrintBack printBack) throws MeterException {
    //     Print0000Request request = new Print0000Request();
    //     request.setPrintBack(printBack);
    //     this.sendAll(request);
    // }

    /**
     * @description: 设置打印机参数
     **/
    default void setPrintParam(IPrintBack printBack, PrintSetRequest request) throws MeterException {
        Print0100Request print0100Request = new Print0100Request();
        print0100Request.setPrintBack(printBack);
        print0100Request.setItem(request.getItem());
        print0100Request.setSave(request.getSave());
        print0100Request.setVal(request.getVal());
        this.cmdSend(print0100Request);
    }

    /**
     * @description: 设置打印机灰度（0-15）
     **/
    default void setPrintGrayscale(IPrintBack printBack, PrintParamSave save, Integer val) throws MeterException {
        Print0100Request request = new Print0100Request();
        request.setPrintBack(printBack);
        request.setItem(0);
        request.setSave(save);
        request.setVal(val);
        this.cmdSend(request);
    }

    /**
     * @description: 打开钱箱
     **/
    default void openBox(IPrintBack printBack) throws MeterException {
        Print0300Request request = new Print0300Request();
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    /**
     * @description: 读卡
     **/
    default void readCard(int delay, IPrintBack printBack) throws MeterException {
        Print0400Request request = new Print0400Request();
        request.specify(delay);
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    /**
     * @description: 写卡
     **/
    default void writeCard(EntityCard entityCard, IPrintBack printBack) throws MeterException {
        Print0500Request request = new Print0500Request();
        request.setInnerId(entityCard.getInnerId());
        request.setOuterId(entityCard.getOuterId());
        request.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt());
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    /**
     * @description: 卡计数+1
     **/
    default void countup(EntityCard entityCard, IPrintBack printBack) throws MeterException {
        Print0600Request request = new Print0600Request();
        request.setInnerId(entityCard.getInnerId());
        request.setOuterId(entityCard.getOuterId());
        request.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt());
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    /**
     * @description: 读卡号
     **/
    default void readCardNo(int delay, IPrintBack printBack) throws MeterException {
        Print0700Request request = new Print0700Request();
        request.specify(delay);
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    /**
     * @description: 走纸
     * A 常规走纸 效果等同于按住走纸键
     * B 标定走纸 效果等同于按住走纸键（小打印机等同于A）
     * C 工作走纸 不清楚错误的情况下走纸
     **/
    default void paper(char model, IPrintBack printBack) throws MeterException {
        Print0D00Request request = new Print0D00Request();
        request.setModel(model);
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }
}
