package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.entity.DeviceReport;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;
import com.jhscale.meter.protocol.print.line.PrintLine;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.RealBitmapPrintRequest;

import java.util.Arrays;
import java.util.List;

/**
 * @author lie_w
 * @title: IPrintData
 * @projectName jhscale-agreement
 * @description: 打印数据
 * @date 2021-01-118:27
 */
public interface IPrintData<T extends IPrintData> extends IPrintBasic {

    /**
     * @description: 发送打印数据
     **/
    default void printSend(PrintDataRequest request) throws MeterException {
        this.send(request);
    }

    /**
     * @description: 添加打印部分信息
     **/
    default T addParas(Para... paras) throws MeterException {
        if (paras != null && paras.length > 0) {
            this.communication().addParas(Arrays.asList(paras));
        }
        return (T) this;
    }

    /**
     * @description: 添加打印部分信息
     **/
    default T addParas(List<Para> paras) throws MeterException {
        if (paras != null && !paras.isEmpty()) {
            this.communication().addParas(paras);
        }
        return (T) this;
    }

    /**
     * @description: 清空缓冲的打印部件信息
     **/
    default T clearParas() throws MeterException {
        this.communication().clearPara();
        return (T) this;
    }

    /**
     * @description: 获取缓冲的打印部件信息
     **/
    default List<Para> getParas() throws MeterException {
        return this.communication().paras();
    }

    /**
     * @description: 缓冲区发送打印
     **/
    default void printSend(IPrintBack printBack) throws MeterException {
        List<Para> paras = this.getParas();
        if (paras == null || paras.isEmpty())
            throw new MeterException(MeterStateEnum.打印部件不能为空);
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setParas(paras);
        this.send(request);
        this.clearParas();
    }

    /**
     * @description: 直接发送打印数据打印
     **/
    default void printSend(IPrintBack printBack, Para... paras) throws MeterException {
        if (paras == null || paras.length == 0)
            throw new MeterException(MeterStateEnum.打印部件不能为空);
        this.Print_Para(printBack, Arrays.asList(paras));
    }

    default void Print_Para(IPrintBack printBack, List<Para> paras) throws MeterException {
        if (paras == null || paras.isEmpty())
            throw new MeterException(MeterStateEnum.打印部件不能为空);
        for (Para para : paras) {
            if (para instanceof RealBitmapPara)
                throw new MeterException(MeterStateEnum.实时位图使用专用接口);
        }
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setParas(paras);
        this.send(request);
    }

    /**
     * @description: 直接发送打印数据打印
     **/
    default void printSend(IPrintBack printBack, PrintLine... lines) throws MeterException {
        if (lines == null || lines.length == 0)
            throw new MeterException(MeterStateEnum.行模式不能为空);
        this.Print_Line(printBack, Arrays.asList(lines));
    }

    default void Print_Line(IPrintBack printBack, List<PrintLine> lines) throws MeterException {
        if (lines == null || lines.isEmpty())
            throw new MeterException(MeterStateEnum.行模式不能为空);
        PrintDataRequest request = new PrintDataRequest();
        for (PrintLine line : lines) {
            if (line != null) line.add(request);
        }
        request.setPrintBack(printBack);
        this.send(request);
    }

    /**
     * @description: 发送实时位图
     **/
    @Deprecated
    default void realBitmapSend(RealBitmapPrintRequest request) throws MeterException {
        throw new MeterException(MeterStateEnum.API废弃);
        // RealBitmapPara bitmapPara = new RealBitmapPara()
        //         .setStartX(request.getStart_x())
        //         .setStartY(request.getStart_y())
        //         .setBitMap(request.getBitMap());

        // PrintRealBitmapRequest bitmapRequest = new PrintRealBitmapRequest(bitmapPara, request.isPrint(), request.isPaper());
        // bitmapRequest.setPrintBack(request.getPrintBack());
        // this.communication().sendCmd(bitmapRequest);
    }

    /**
     * @description: 打印报表
     **/
    default void printReport(IPrintBack printBack, DeviceReport report) throws MeterException {
        this.addParas(report.topPara())
                .addParas(report.datePara())
                .addParas(report.splitPara())
                .addParas(report.innerPara(report.getMoney(), report.getWeight()))
                .addParas(report.splitPara())
                .addParas(report.cuttingPara());
        this.printSend(printBack);
    }
}
