package com.jhscale.meter.protocol.print.produce;

import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.link.Messenger;

/**
 * @author lie_w
 * @title: IPrint
 * @projectName jhscale-agreement
 * @description: 打印操作
 * @date 2021-01-0513:36
 */
public interface IPrintManager<T extends IPrintManager> extends IPrintBasic {

    /*********************************** 全局参数 *************************************/

    /**
     * @description: 添加加密对象
     **/
    default T addEncryptDecrypt(RSAEncryptDecrypt encryptDecrypt) {
        PrintFactory.getInstance().addRSAEncryptDecrypt(encryptDecrypt);
        return (T) this;
    }

    /**
     * @description: 添加图片处理器
     **/
    default T setImageProcess(ImageProcess imageProcess) {
        PrintFactory.getInstance().setImageProcess(imageProcess);
        return (T) this;
    }

    /**
     * @description: 设置字符集
     **/
    default T setCharset(String charset) {
        PrintFactory.getInstance().setCharset(charset);
        return (T) this;
    }

    /*********************************** 全局参数 *************************************/

    /**
     * @description: 添加通讯器
     **/
    T setMessenger(Messenger messenger) throws MeterException;

    /**
     * @description: 添加通讯器
     **/
    T setMessenger(Integer serial, Messenger messenger);

    /**
     * @description: 停止
     **/
    default void close() throws MeterException {
        PrintCommunication communication = this.communication();
        if (communication != null) communication.closeMessenger();

    }

    /**
     * @description: 日志开关
     **/
    default void logSwitch(boolean _switch, Integer _length) throws MeterException {
        PrintCommunication communication = this.communication();
        if (communication != null) communication.logSwitch(_switch, _length);
    }
}
