package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.bitmap.FileBitMap;
import com.jhscale.meter.protocol.print.entity.file.PrintFileRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.file.upgrade.PrintUpgradeRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;

import java.io.File;
import java.io.InputStream;

/**
 * @author lie_w
 * @title: IPrintUpgrade
 * @projectName jhscale-agreement
 * @description: 升级
 * @date 2021-01-118:33
 */
public interface IPrintUpgrade extends IPrintBasic {

    /**
     * @description: 文件升级
     **/
    default void fileUpgrade(PrintFileRequest request) throws MeterException {
        this.communication().upgrade(request);
    }

    /**
     * @description: 位图升级
     **/
    default void bitMapUpgrade(PrintBitMapRequest request) throws MeterException {
        this.communication().upgrade(request);
    }

    /**
     * @description: 位图升级文件升级
     **/
    default void bitMapUpgrade(IPrintBack printBack, File file) throws MeterException {
        PrintBitMapRequest request = new PrintBitMapRequest(file);
        request.setPrintBack(printBack);
        this.bitMapUpgrade(request);
    }

    /**
     * @description: 位图升级文件升级
     **/
    default void bitMapUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
        PrintBitMapRequest request = new PrintBitMapRequest(name, inputStream);
        request.setPrintBack(printBack);
        this.bitMapUpgrade(request);
    }

    /**
     * @description: 位图源文件升级
     **/
    default void bitMapUpgrade(IPrintBack printBack, FileBitMap bitMap) throws MeterException {
        PrintBitMapRequest request = new PrintBitMapRequest(bitMap.getSource().getName(), bitMap.getContent());
        request.setPrintBack(printBack);
        this.bitMapUpgrade(request);
    }

    /**
     * @description: 位图源文件升级
     **/
    default void bitMapUpgrade(IPrintBack printBack, File source, Double rate, Integer number) throws MeterException {
        this.bitMapUpgrade(printBack, new FileBitMap()
                .addSource(source)
                .compress(rate)
                .preterate()
                .setNumber(number)
                .bulid());
    }

    /**
     * @description: 位图源文件升级
     **/
    default void bitMapUpgrade(IPrintBack printBack, File source, Integer width, Integer height, Integer number) throws MeterException {
        this.bitMapUpgrade(printBack, new FileBitMap()
                .addSource(source)
                .compress(width, height)
                .preterate()
                .setNumber(number)
                .bulid());
    }

    /**
     * @description: 字库升级
     **/
    default void fontUpgrade(PrintFontRequest request) throws MeterException {
        this.communication().upgrade_all(request);
    }

    /**
     * @description: 字库升级
     **/
    default void fontUpgrade(IPrintBack printBack, File file) throws MeterException {
        PrintFontRequest request = new PrintFontRequest(file);
        request.setPrintBack(printBack);
        this.fontUpgrade(request);
    }

    /**
     * @description: 字库检查
     **/
    default void fontUpgradeCheck(IPrintBack printBack, File file) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintFontRequest(file)), printBack);
    }

    /**
     * @description: 字库升级
     **/
    default void fontUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
        PrintFontRequest request = new PrintFontRequest(name, inputStream);
        request.setPrintBack(printBack);
        this.fontUpgrade(request);
    }

    /**
     * @description: 字库检查
     **/
    default void fontUpgradeCheck(IPrintBack printBack, String name) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintFontRequest(name)), printBack);
    }

    /**
     * @description: 固件升级
     **/
    default void versionUpgrade(PrintUpgradeRequest request) throws MeterException {
        this.communication().upgrade(request);
    }

    /**
     * @description: 固件升级
     **/
    default void versionUpgrade(IPrintBack printBack, File file) throws MeterException {
        PrintUpgradeRequest request = new PrintUpgradeRequest(file);
        request.setPrintBack(printBack);
        this.versionUpgrade(request);
    }

    /**
     * @description: 固件升级检查
     **/
    default void versionUpgradeCheck(IPrintBack printBack, File file) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintUpgradeRequest(file)), printBack);
    }

    /**
     * @description: 固件升级
     **/
    default void versionUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
        PrintUpgradeRequest request = new PrintUpgradeRequest(name, inputStream);
        request.setPrintBack(printBack);
        this.versionUpgrade(request);
    }

    /**
     * @description: 固件升级检查
     **/
    default void versionUpgradeCheck(IPrintBack printBack, String name) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintUpgradeRequest(name)), printBack);
    }
}
