package com.jhscale.meter.protocol.print.produce.entity;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.PrintStateCode;

/**
 * @author lie_w
 * @title: Response
 * @projectName jhscale-agreement
 * @description: 打印回调响应结果
 * @date 2021-01-1115:47
 */
public class PrintBackResponse implements JSONModel {

    // 打印机序号
    private Integer serial;

    // 等级 0-正常 1-异常 2-警告
    private int level;

    // 状态码
    private String code;

    // 异常信息
    private String msg;

    // 业务结果
    private boolean linkResult;

    /**
     * @description: 成功
     **/
    public static PrintBackResponse success(Integer serial) {
        PrintBackResponse response = new PrintBackResponse();
        response.setSerial(serial);
        response.setLevel(PrintStateCode.BIZ_SUCCESS);
        response.setCode(PrintStateCode.SUCCESS);
        response.setLinkResult(true);
        return response;
    }

    /**
     * @description: 失败
     **/
    public static PrintBackResponse fail(Integer serial, String code, String msg) {
        PrintBackResponse response = new PrintBackResponse();
        response.setSerial(serial);
        response.setLevel(PrintStateCode.BIZ_ERROR);
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    /**
     * @description: 失败
     **/
    public static PrintBackResponse fail(Integer serial, MeterStateEnum stateEnum) {
        PrintBackResponse response = new PrintBackResponse();
        response.setSerial(serial);
        response.setCode(stateEnum.getCode());
        response.setMsg(stateEnum.getMsg());
        return response;
    }

    /**
     * @description: 失败
     **/
    public static PrintBackResponse warning(Integer serial, String code, String msg) {
        PrintBackResponse response = new PrintBackResponse();
        response.setSerial(serial);
        response.setLevel(PrintStateCode.BIZ_WARNING);
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    /**
     * @description: 失败
     **/
    public static PrintBackResponse warning(Integer serial, MeterStateEnum stateEnum) {
        PrintBackResponse response = new PrintBackResponse();
        response.setSerial(serial);
        response.setLevel(PrintStateCode.BIZ_WARNING);
        response.setCode(stateEnum.getCode());
        response.setMsg(stateEnum.getMsg());
        return response;
    }

    public Integer getSerial() {
        return serial;
    }

    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isLinkResult() {
        return linkResult;
    }

    public void setLinkResult(boolean linkResult) {
        this.linkResult = linkResult;
    }

    @Override
    public String toString() {
        return "PrintBackResponse{" +
                "serial=" + serial +
                ", level=" + level +
                ", code='" + code + '\'' +
                ", msg='" + msg + '\'' +
                ", linkResult=" + linkResult +
                '}';
    }
}
