package com.jhscale.meter.protocol.print.produce.entity;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.protocol.print.entity.bitmap.RealBitMap;
import com.jhscale.meter.protocol.print.link.IPrintBack;

/**
 * @author Loveven
 * @title: RealBitmapPrintRequest
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-2916:14
 */
public class RealBitmapPrintRequest implements JSONModel {

    // 回调事件
    private IPrintBack printBack;

    // 起始X坐标
    private Integer start_x;

    // 起始Y坐标
    private Integer start_y;

    // 位图源信息
    private RealBitMap bitMap;

    // 位图发送成功打印
    private boolean print = false;

    // 走纸到撕纸位
    private boolean paper = false;

    public RealBitmapPrintRequest setPrintBack(IPrintBack printBack) {
        this.printBack = printBack;
        return this;
    }

    public RealBitmapPrintRequest setStartX(Integer start_x) {
        this.start_x = start_x;
        return this;
    }

    public RealBitmapPrintRequest setStartY(Integer start_y) {
        this.start_y = start_y;
        return this;
    }

    public RealBitmapPrintRequest setBitMap(RealBitMap bitMap) {
        this.bitMap = bitMap;
        return this;
    }

    public RealBitmapPrintRequest setPrint(boolean print) {
        this.print = print;
        return this;
    }

    public RealBitmapPrintRequest setPaper(boolean paper) {
        this.paper = paper;
        return this;
    }

    public IPrintBack getPrintBack() {
        return printBack;
    }

    public Integer getStart_x() {
        return start_x;
    }

    public Integer getStart_y() {
        return start_y;
    }

    public RealBitMap getBitMap() {
        return bitMap;
    }

    public boolean isPrint() {
        return print;
    }

    public boolean isPaper() {
        return paper;
    }
}
