package com.jhscale.meter.protocol.print.produce.entity;

/**
 * @author lie_w
 * @title: PrintSendResponse
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-120:20
 */
public class TradePrintResponse extends PrintSendResponse {

    // 打印机工作状态 true 空闲 false 工作中
    private boolean busy;

    // 缓冲状态 true 无缓冲 false 有缓冲
    private boolean cache;

    // 纸张状态 true 正常 false 缺纸
    private boolean paper;

    // 热敏状态 true 正常 false 过热冷却中
    private boolean thermal;

    // 打印纸未取走 true 存在 false 不存在
    private boolean printing;

    // 打印机关闭 true 未关闭 false 已关闭
    private boolean close;

    // 当前页数
    private Integer now;

    // 总页数
    private Integer total;

    /**
     * @description: 检查是否结束
     **/
    public boolean finish() {
        return this.now != 0 && this.now == this.total;
    }

    public boolean isBusy() {
        return busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public boolean isCache() {
        return cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isPaper() {
        return paper;
    }

    public void setPaper(boolean paper) {
        this.paper = paper;
    }

    public boolean isThermal() {
        return thermal;
    }

    public void setThermal(boolean thermal) {
        this.thermal = thermal;
    }

    public boolean isPrinting() {
        return printing;
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
    }

    public boolean isClose() {
        return close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public Integer getNow() {
        return now;
    }

    public void setNow(Integer now) {
        this.now = now;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }
}
