package com.jhscale.meter.protocol.print.produce.impl;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.PrintNode;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.produce.IPrintCmd;
import com.jhscale.meter.protocol.print.produce.IPrintData;
import com.jhscale.meter.protocol.print.produce.IPrintManager;
import com.jhscale.meter.protocol.print.produce.IPrintUpgrade;

/**
 * @author lie_w
 * @title: PrintProcessor
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/10/289:09
 */
public class PrintProcessor implements IPrintManager<PrintProcessor>, IPrintData, IPrintCmd, IPrintUpgrade {

    // 打印通讯器
    private PrintCommunication communication;

    // 是否获取默认
    private boolean first;

    /**
     * @param messenger
     * @description: 添加通讯器
     */
    @Override
    public PrintProcessor setMessenger(Messenger messenger) throws MeterException {
        throw new MeterException(MeterStateEnum.API废弃);
    }

    /**
     * @param serial
     * @param messenger
     * @description: 添加通讯器
     */
    @Override
    public PrintProcessor setMessenger(Integer serial, Messenger messenger) {
        this.addCommunication(new PrintNode(serial, messenger));
        PrintGeneralFactory.getInstance().Put_Print(this);
        return this;
    }

    /**
     * @description: 获取当前通讯器
     **/
    @Override
    public PrintCommunication communication() {
        return this.communication;
    }

    void addCommunication(PrintCommunication communication) {
        this.communication = communication;
    }

    public boolean isFirst() {
        return first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }
}
