package com.jhscale.meter.protocol.print.produce.impl;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.data.PrintDataParse;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.produce.IPrintTemplate;
import com.jhscale.meter.protocol.print.temp.Temp;

import java.util.List;

/**
 * @author lie_w
 * @title: PrintServiceImpl
 * @projectName jhscale-agreement
 * @description: 打印生产
 * @date 2021-01-0513:38
 */
public class PrintProduce extends PrintProcessor implements IPrintTemplate {

    // 打印缓冲区
    // private List<Para> paraCache;

    /**
     * @description: 添加通讯器
     **/
    @Override
    public PrintProduce setMessenger(Messenger messenger) {
        PrintFactory printFactory = PrintFactory.getInstance().build(PrintConstant.DEFAULT_PRINT, messenger);
        this.addCommunication(printFactory);
        PrintGeneralFactory.getInstance().Put_Print(this);
        return this;
    }

    /**
     * @param printParts
     * @description: 设置打印模板
     */
    @Override
    public void setPrintPart(List<PrintDataParse.PrintPart> printParts) throws MeterException {
        PrintFactory.getInstance().setPrintParts(printParts);
    }

    /**
     * @param template
     * @description: 设置打印模板
     */
    @Override
    public void setPringPart(String template) throws MeterException {
        PrintFactory.getInstance().templateAnalysisAndSet(template);
    }

    /**
     * @param template
     * @description: 解析打印模板
     */
    @Override
    public List<PrintDataParse.PrintPart> parseTemplate(String template) throws MeterException {
        return PrintFactory.getInstance().templateAnalysis(template);
    }

    /**
     * @param printVal
     * @description: 使用模板打印数据
     */
    @Override
    public String printVal(PrintVal printVal) throws MeterException {
        return PrintFactory.getInstance().assemblePrintData(printVal);
    }

    /**
     * @param printBack
     * @param printVal
     * @description: 发送模板打印数据
     */
    @Override
    public void printVal(IPrintBack printBack, PrintVal printVal) throws MeterException {
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setData(this.printVal(printVal));
        PrintFactory.getInstance().sendData(request);
    }

    /**
     * @param printBack
     * @param printVal
     * @description: 发送模板1号打印数据
     */
    @Override
    @Deprecated
    public void printValTemp1(IPrintBack printBack, PrintVal printVal) throws MeterException {
        PrintFactory.getInstance().printTemp(printBack, printVal);
    }

    /**
     * @param printBack
     * @param printVal
     * @param temp
     * @description: 发送模板打印数据
     */
    @Override
    public void printValTemp(IPrintBack printBack, PrintVal printVal, Temp temp) throws MeterException {
        PrintFactory.getInstance().printTemp(printBack, printVal, temp);
    }

//    /**
//     * @param encryptDecrypt
//     * @description: 添加加密对象
//     */
//    @Override
//    public PrintProduce addEncryptDecrypt(RSAEncryptDecrypt encryptDecrypt) {
//        PrintFactory.getInstance().addRSAEncryptDecrypt(encryptDecrypt);
//        return this;
//    }

//    /**
//     * @param imageProcess
//     * @description: 添加图片处理器
//     */
//    @Override
//    public PrintProduce setImageProcess(ImageProcess imageProcess) {
//        PrintFactory.getInstance().setImageProcess(imageProcess);
//        return this;
//    }

//    /**
//     * @param charset
//     * @description: 设置字符集
//     */
//    @Override
//    public PrintProduce setCharset(String charset) {
//        PrintFactory.getInstance().setCharset(charset);
//        return this;
//    }

//    /**
//     * @description: 停止
//     **/
//    @Override
//    public void close() {
//        PrintFactory.getInstance().closeMessenger();
//    }

//    /**
//     * @param _switch
//     * @description: 日志开关
//     */
//    @Override
//    public void logSwitch(boolean _switch, Integer _length) {
//        PrintFactory.getInstance().logSwitch(_switch, _length);
//    }

//    /**
//     * @param printType
//     * @param request
//     * @description: 直接发送 Content 内容信息
//     */
//    @Override
//    public void send(PrintType printType, PrintRequest request) throws MeterException {
//        request.printType();
//        PrintFactory.getInstance().sendData(request);
//    }

//    /**
//     * @param request
//     * @description: 发送命令操作(不需要获取内存空间)
//     */
//    @Override
//    public void sendAll(PrintRequest request) throws MeterException {
//        PrintFactory.getInstance().sendDataWithAllPackage(request);
//    }

//    /**
//     * @param request
//     * @description: 发送打印数据
//     */
//    @Override
//    public void printSend(PrintDataRequest request) throws MeterException {
//        PrintFactory.getInstance().sendData(request);
//    }

//    /**
//     * @param paras
//     * @description: 添加打印部分信息
//     */
//    @Override
//    public PrintProduce addParas(Para... paras) throws MeterException {
//        return this.addParas(Arrays.asList(paras));
//    }
//
//    /**
//     * @param paras
//     * @description: 添加打印部分信息
//     */
//    @Override
//    public PrintProduce addParas(List<Para> paras) throws MeterException {
//        if (this.paraCache == null) this.paraCache = new ArrayList<>();
//        if (paras == null || paras.isEmpty()) {
//            // throw new MeterException(MeterStateEnum.打印部件不能为空);
//            return this;
//        }
//        PrintUtils.debug(null, paras);
//        for (Para para : paras) {
//            if (para instanceof RealBitmapPara)
//                throw new MeterException(MeterStateEnum.实时位图使用专用接口);
//        }
//        this.paraCache.addAll(paras);
//        return this;
//    }
//
//    /**
//     * @description: 清空缓冲的打印部件信息
//     **/
//    @Override
//    public void clearParas() {
//        if (this.paraCache != null)
//            this.paraCache.clear();
//    }
//
//    /**
//     * @description: 获取缓冲的打印部件信息
//     **/
//    @Override
//    public List<Para> getParas() {
//        return this.paraCache;
//    }
//
//    /**
//     * @param printBack
//     * @description: 缓冲区发送打印
//     */
//    @Override
//    public void printSend(IPrintBack printBack) throws MeterException {
//        if (this.paraCache == null || this.paraCache.isEmpty())
//            throw new MeterException(MeterStateEnum.打印部件缓冲区为空);
//        PrintDataRequest request = new PrintDataRequest();
//        request.setPrintBack(printBack);
//        request.setParas(this.paraCache);
//        PrintFactory.getInstance().sendData(request);
//        this.clearParas();
//    }
//
//    /**
//     * @param printBack
//     * @param paras
//     * @description: 直接发送打印数据打印
//     */
//    @Override
//    public void printSend(IPrintBack printBack, Para... paras) throws MeterException {
//        if (this.paraCache == null || this.paraCache.isEmpty())
//            throw new MeterException(MeterStateEnum.打印部件不能为空);
//        for (Para para : paras) {
//            if (para instanceof RealBitmapPara)
//                throw new MeterException(MeterStateEnum.实时位图使用专用接口);
//        }
//        PrintDataRequest request = new PrintDataRequest();
//        request.setPrintBack(printBack);
//        request.setParas(Arrays.asList(paras));
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @description: 发送实时位图
//     **/
//    @Override
//    public void realBitmapSend(RealBitmapPrintRequest request) throws MeterException {
//        RealBitmapPara bitmapPara = new RealBitmapPara()
//                .setStartX(request.getStart_x())
//                .setStartY(request.getStart_y())
//                .setBitMap(request.getBitMap());
//
//        PrintRealBitmapRequest bitmapRequest = new PrintRealBitmapRequest(bitmapPara, request.isPrint(), request.isPaper());
//        bitmapRequest.setPrintBack(request.getPrintBack());
//        PrintFactory.getInstance()
//                .setMessenger(new DefaultPrintSerialMessenger())
//                .sendCmd(bitmapRequest);
//    }
//
//    /**
//     * @param printBack
//     * @param report
//     * @description: 打印报表
//     */
//    @Override
//    public void printReport(IPrintBack printBack, DeviceReport report) throws MeterException {
//        this.addParas(report.topPara())
//                .addParas(report.datePara())
//                .addParas(report.splitPara())
//                .addParas(report.innerPara(report.getMoney(), report.getWeight()))
//                .addParas(report.splitPara())
//                .addParas(report.cuttingPara());
//        this.printSend(printBack);
//    }

//    /**
//     * @param request
//     * @description: 发送命令操作
//     */
//    @Override
//    public void cmdSend(PrintCmdRequest request) throws MeterException {
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param printBack
//     * @description: 获取打印机信息
//     */
//    @Override
//    public void getPrintInfo(IPrintBack printBack) throws MeterException {
//        Print0000Request request = new Print0000Request();
//        request.setPrintBack(printBack);
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param request
//     * @description: 设置打印机参数
//     */
//    @Override
//    public void setPrintParam(IPrintBack printBack, PrintSetRequest request) throws MeterException {
//        Print0100Request print0100Request = new Print0100Request();
//        print0100Request.setPrintBack(printBack);
//        print0100Request.setItem(request.getItem());
//        print0100Request.setSave(request.getSave());
//        print0100Request.setVal(request.getVal());
//        PrintFactory.getInstance().sendData(print0100Request);
//    }
//
//    /**
//     * @param printBack
//     * @param save
//     * @param val
//     * @description: 设置打印机灰度（0-15）
//     */
//    @Override
//    public void setPrintGrayscale(IPrintBack printBack, PrintParamSave save, Integer val) throws MeterException {
//        Print0100Request request = new Print0100Request();
//        request.setPrintBack(printBack);
//        request.setItem(0);
//        request.setSave(save);
//        request.setVal(val);
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param printBack
//     * @description: 打开钱箱
//     */
//    @Override
//    public void openBox(IPrintBack printBack) throws MeterException {
//        Print0300Request request = new Print0300Request();
//        request.setPrintBack(printBack);
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param delay
//     * @param printBack
//     * @description: 读卡
//     */
//    @Override
//    public void readCard(int delay, IPrintBack printBack) throws MeterException {
//        Print0400Request request = new Print0400Request();
//        request.specify(delay);
//        request.setPrintBack(printBack);
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param entityCard
//     * @param printBack
//     * @description: 写卡
//     */
//    @Override
//    public void writeCard(EntityCard entityCard, IPrintBack printBack) throws MeterException {
//        Print0500Request request = new Print0500Request();
//        request.setInnerId(entityCard.getInnerId());
//        request.setOuterId(entityCard.getOuterId());
//        request.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt());
//        request.setPrintBack(printBack);
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param entityCard
//     * @param printBack
//     * @description: 卡计数+1
//     */
//    @Override
//    public void countup(EntityCard entityCard, IPrintBack printBack) throws MeterException {
//        Print0600Request request = new Print0600Request();
//        request.setInnerId(entityCard.getInnerId());
//        request.setOuterId(entityCard.getOuterId());
//        request.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt());
//        request.setPrintBack(printBack);
//        PrintFactory.getInstance().sendData(request);
//    }
//
//    /**
//     * @param delay
//     * @param printBack
//     * @description: 读卡号
//     */
//    @Override
//    public void readCardNo(int delay, IPrintBack printBack) throws MeterException {
//        Print0700Request request = new Print0700Request();
//        request.specify(delay);
//        request.setPrintBack(printBack);
//        PrintFactory.getInstance().sendData(request);
//    }

//    /**
//     * @param request
//     * @description: 文件升级
//     */
//    @Override
//    public void fileUpgrade(PrintFileRequest request) throws MeterException {
//        PrintFactory.getInstance().upgrade(request);
//    }
//
//    /**
//     * @param request
//     * @description: 位图升级
//     */
//    @Override
//    public void bitMapUpgrade(PrintBitMapRequest request) throws MeterException {
//        PrintFactory.getInstance().upgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param file
//     * @description: 位图升级文件升级
//     */
//    @Override
//    public void bitMapUpgrade(IPrintBack printBack, File file) throws MeterException {
//        PrintBitMapRequest request = new PrintBitMapRequest(file);
//        request.setPrintBack(printBack);
//        this.bitMapUpgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param inputStream
//     * @description: 位图升级文件升级
//     */
//    @Override
//    public void bitMapUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
//        PrintBitMapRequest request = new PrintBitMapRequest(name, inputStream);
//        request.setPrintBack(printBack);
//        this.bitMapUpgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param bitMap
//     * @description: 位图源文件升级
//     */
//    @Override
//    public void bitMapUpgrade(IPrintBack printBack, FileBitMap bitMap) throws MeterException {
//        PrintBitMapRequest request = new PrintBitMapRequest(bitMap.getSource().getName(), bitMap.getContent());
//        request.setPrintBack(printBack);
//        this.bitMapUpgrade(request);
//    }
//
//    /**
//     * @param printBack 回调
//     * @param source    源文件
//     * @param rate      缩放比例
//     * @param number    位图编号
//     * @description: 位图源文件升级
//     */
//    @Override
//    public void bitMapUpgrade(IPrintBack printBack, File source, Double rate, Integer number) throws MeterException {
//        this.bitMapUpgrade(printBack, new FileBitMap()
//                .addSource(source)
//                .compress(rate)
//                .preterate()
//                .setNumber(number)
//                .bulid());
//    }
//
//    /**
//     * @param printBack 回调
//     * @param source    源文件
//     * @param width     缩放宽
//     * @param height    缩放高
//     * @param number    位图编号
//     * @description: 位图源文件升级
//     */
//    @Override
//    public void bitMapUpgrade(IPrintBack printBack, File source, Integer width, Integer height, Integer number) throws MeterException {
//        this.bitMapUpgrade(printBack, new FileBitMap()
//                .addSource(source)
//                .compress(width, height)
//                .preterate()
//                .setNumber(number)
//                .bulid());
//    }
//
//    /**
//     * @param request
//     * @description: 字库升级
//     */
//    @Override
//    public void fontUpgrade(PrintFontRequest request) throws MeterException {
//        PrintFactory.getInstance().upgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param file
//     * @description: 字库升级
//     */
//    @Override
//    public void fontUpgrade(IPrintBack printBack, File file) throws MeterException {
//        PrintFontRequest request = new PrintFontRequest(file);
//        request.setPrintBack(printBack);
//        this.fontUpgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param file
//     * @description: 字库检查
//     */
//    @Override
//    public void fontUpgradeCheck(IPrintBack printBack, File file) throws MeterException {
//        PrintFontRequest request = new PrintFontRequest(file);
//        PrintFactory factory = PrintFactory.getInstance();
//        factory.checkUpgrade(factory.getUpgradeFileParam(request), printBack);
//    }
//
//    /**
//     * @param printBack
//     * @param inputStream
//     * @description: 字库升级
//     */
//    @Override
//    public void fontUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
//        PrintFontRequest request = new PrintFontRequest(name, inputStream);
//        request.setPrintBack(printBack);
//        this.fontUpgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param name
//     * @description: 字库检查
//     */
//    @Override
//    public void fontUpgradeCheck(IPrintBack printBack, String name) throws MeterException {
//        PrintFontRequest request = new PrintFontRequest();
//        request.setName(name);
//        PrintFactory factory = PrintFactory.getInstance();
//        factory.checkUpgrade(factory.getUpgradeFileParam(request), printBack);
//    }
//
//    /**
//     * @param request
//     * @description: 固件升级
//     */
//    @Override
//    public void versionUpgrade(PrintUpgradeRequest request) throws MeterException {
//        PrintFactory.getInstance().upgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param file
//     * @description: 固件升级
//     */
//    @Override
//    public void versionUpgrade(IPrintBack printBack, File file) throws MeterException {
//        PrintUpgradeRequest request = new PrintUpgradeRequest(file);
//        request.setPrintBack(printBack);
//        this.versionUpgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param file
//     * @description: 固件升级检查
//     */
//    @Override
//    public void versionUpgradeCheck(IPrintBack printBack, File file) throws MeterException {
//        PrintUpgradeRequest request = new PrintUpgradeRequest(file);
//        PrintFactory factory = PrintFactory.getInstance();
//        factory.checkUpgrade(factory.getUpgradeFileParam(request), printBack);
//    }
//
//    /**
//     * @param printBack
//     * @param inputStream
//     * @description: 固件升级
//     */
//    @Override
//    public void versionUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
//        PrintUpgradeRequest request = new PrintUpgradeRequest(name, inputStream);
//        request.setPrintBack(printBack);
//        this.versionUpgrade(request);
//    }
//
//    /**
//     * @param printBack
//     * @param name
//     * @description: 固件升级检查
//     */
//    @Override
//    public void versionUpgradeCheck(IPrintBack printBack, String name) throws MeterException {
//        PrintUpgradeRequest request = new PrintUpgradeRequest();
//        request.setName(name);
//        PrintFactory factory = PrintFactory.getInstance();
//        factory.checkUpgrade(factory.getUpgradeFileParam(request), printBack);
//    }
}