package com.jhscale.meter.protocol.print.temp;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: Temp1
 * @projectName jhscale-agreement
 * @description: 会员条码打印
 * @date 2020-12-259:51
 */
public class Temp2 implements Temp{

    private static final String TEMPLATE = "033016000000000000000080011A0001000412000000010000000080011A00\n" +
            "S0\n" +
            "0412000005010000000080011A00\n" +
            "S17\n" +
            "0412000005010000000080011A00\n" +
            "S18\n" +
            "0412000005010000000080011A00\n" +
            "S19\n" +
            "0412000005010000000080011A00\n" +
            "S20\n" +
            "0412000004010000000054001A00\n" +
            "S2\n" +
            "1200000401540000001E001A00\n" +
            "S47\n" +
            "1200000501800000007D001A00\n" +
            "S31\n" +
            "1200000501030100007D001A00\n" +
            "S26\n" +
            "0412000004010000000072001A00\n" +
            "T销售时间:\n" +
            "1200000001730000008C001A00\n" +
            "S3\n" +
            "12000006010E01000070001A00\n" +
            "S4\n" +
            "120000050000001A0080011000\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -\n" +
            "04\n" +
            "12000004010000000068001A00\n" +
            "T商品名称\n" +
            "1200000401B5000000A0001A00\n" +
            "T商品编号\n" +
            "12000004010E001A004C001A00\n" +
            "T单价\n" +
            "120000050163001A00AC001A00\n" +
            "T净重/数量\n" +
            "120000050118011A0068001A00\n" +
            "T金额\n" +
            "12000005000000340080010F00\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -\n" +
            "04\n" +
            "z\n" +
            "120000040100000000B4001A00\n" +
            "I0-0\n" +
            "1200000401B4000000C8001A00\n" +
            "I0-6\n" +
            "12000004010000000080001A00\n" +
            "I0-20\n" +
            "12000005018000000080001A00\n" +
            "I0-21\n" +
            "12000006010001000080001A00\n" +
            "I0-22\n" +
            "120000060100001A0060001A00\n" +
            "I0-4\n" +
            "120040060160001A0060001A00\n" +
            "I0-5\n" +
            "1200000401C0001A0060001A00\n" +
            "I0-1\n" +
            "120000060120011A0060001A00\n" +
            "I0-26\n" +
            "12004006012001000060001A00\n" +
            "I0-27\n" +
            "04\n" +
            "Z\n" +
            "12000005000000000080011200\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -\n" +
            "04\n" +

            "#14\n" +
            "12000004018F00000076001A00\n" +
            "T原价金额:\n" +
            "12004005010501000078001A00\n" +
            "S7\n" +
            "12000004018F001A0076001A00\n" +
            "T节省金额:\n" +
            "120000050105011A0078001A00\n" +
            "S8\n" +
            "#1\n" +
            "04\n" +

            "#1\n" +
            "04120000050204000000C8002200\n" +
            "T实收金额:\n" +
            "1200000502DD000000A0002200\n" +
            "S27\n" +
            "04\n" +

            "#14\n" +
            "12000004018F00000076001A00\n" +
            "T吉卡云支付:\n" +
            "12000005010501000078001A00\n" +
            "S9\n" +
            "12000004018F001A0076001A00\n" +
            "T其他支付:\n" +
            "120000050105011A0078001A00\n" +
            "S10\n" +
            "12000004018F00340076001A00\n" +
            "S11\n" +
            "#1\n" +
            "04\n" +

            "#31\n" +
            "12000004010400000076001A00\n" +
            "T卡号:\n" +
            "12000004018F00000076001A00\n" +
            "T卡原额:\n" +
            "12000005010501000078001A00\n" +
            "S49\n" +
            "120000050100001A008F001A00\n" +
            "S50-0\n" +
            "12000004018F001A0076001A00\n" +
            "T卡余额:\n" +
            "120000050105011A0078001A00\n" +
            "S48\n" +
            "12000004018F00340076001A00\n" +
            "T卡积分:\n" +
            "12000005010501340078001A00\n" +
            "S50\n" +
            "#1\n" +
            "04" +

            "0412000005010000000080011A00\n" +
            "S21\n" +
            "0412000005010000000080011A00\n" +
            "S22\n" +
            "0412000005010000000080011A00\n" +
            "S23\n" +
            "0412000005010000000080011A00\n" +
            "S24\n" +
            "0414000005018000FFFF810074000B00000000000000\n" +
            "R9\n" +
            "040608";

    public void tempInit() throws MeterException {
        // 添加模板映射关系
        Map<String, String> mapping1 = new HashMap<>();
        mapping1.put("S0", "storeName");
        mapping1.put("S17", "text1");
        mapping1.put("S18", "text2");
        mapping1.put("S19", "text3");
        mapping1.put("S20", "text4");
        mapping1.put("S2", "marchaNo");// 机器号
        mapping1.put("S47", "terrace");// 台号
        mapping1.put("S31", "salespersionNo");// 营业员编号
        mapping1.put("S26", "sid");// 当前单号
        mapping1.put("S3", "saleDate");// 销售日期
        mapping1.put("S4", "saleTime");// 销售时间

        Map<String, String> mapping2 = new HashMap<>();
        mapping2.put("I0-0", "pluName");
        mapping2.put("I0-6", "pluNo");
        mapping2.put("I0-4", "price");
        mapping2.put("I0-5", "originalPrice");
        mapping2.put("I0-1", "number");
        mapping2.put("I0-26", "item");
        mapping2.put("I0-27", "originalItem");

        Map<String, String> mapping3 = new HashMap<>();
        mapping3.put("S7", "originalAmount");
        mapping3.put("S8", "thriftAmount");
        mapping3.put("S27", "actualAmount");
        mapping3.put("S9", "storedAmount");
        mapping3.put("S10", "otherAmount");
        mapping3.put("S11", "otherNo");
        mapping3.put("S49", "originalMoney");
        mapping3.put("S50-0", "cardId");
        mapping3.put("S48", "surplusMoney");
        mapping3.put("S50", "surplusIntegral");
        mapping3.put("S21", "text5");
        mapping3.put("S22", "text6");
        mapping3.put("S23", "text7");
        mapping3.put("S24", "text8");
        mapping3.put("R9", "tracebility");// 溯源条码

        PrintFactory.getInstance().templateAnalysisAndSet(TEMPLATE)
                .putMappings(0, mapping1)
                .putMappings(1, mapping2)
                .putMappings(2, mapping3);
    }
}
