package com.jhscale.meter.protocol.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: JKYSettlement
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2222:09
 */
@ApiModel("卡付结算")
public class CardSettlement extends DeviceSettlement<CardSettlement> {

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "卡付金额", name = "cardPay")
    private BigDecimal cardPay = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "积分(当前积分)", name = "point")
    private BigDecimal point = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "原余额（储值+赠送）", name = "balanceOld")
    private BigDecimal balanceOld = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "新余额（储值+赠送）", name = "balanceNew")
    private BigDecimal balanceNew = BigDecimal.ZERO;

    @ApiModelProperty(value = "卡付编号", name = "id")
    private String id;

    @ApiModelProperty(value = "会员主识别码", name = "id_p1")
    private String id_p1;

    @ApiModelProperty(value = "会员副识别码", name = "id_p2")
    private String id_p2;

    public CardSettlement() {
        super(DeviceSettlementType.卡付);
    }

    public BigDecimal cardPay() {
        return Objects.nonNull(this.cardPay) ? this.cardPay : BigDecimal.ZERO;
    }

    public BigDecimal point() {
        return Objects.nonNull(this.point) ? this.point : BigDecimal.ZERO;
    }

    public BigDecimal balanceOld() {
        return Objects.nonNull(this.balanceOld) ? this.balanceOld : BigDecimal.ZERO;
    }

    public BigDecimal balanceNew() {
        return Objects.nonNull(this.balanceNew) ? this.balanceNew : BigDecimal.ZERO;
    }

    public BigDecimal getCardPay() {
        return cardPay;
    }

    public CardSettlement setCardPay(BigDecimal cardPay) {
        this.cardPay = cardPay;
        return this;
    }

    public BigDecimal getPoint() {
        return point;
    }

    public CardSettlement setPoint(BigDecimal point) {
        this.point = point;
        return this;
    }

    public BigDecimal getBalanceOld() {
        return balanceOld;
    }

    public CardSettlement setBalanceOld(BigDecimal balanceOld) {
        this.balanceOld = balanceOld;
        return this;
    }

    public BigDecimal getBalanceNew() {
        return balanceNew;
    }

    public CardSettlement setBalanceNew(BigDecimal balanceNew) {
        this.balanceNew = balanceNew;
        return this;
    }

    public String getId() {
        return id;
    }

    public CardSettlement setId(String id) {
        this.id = id;
        return this;
    }

    public String getId_p1() {
        return id_p1;
    }

    public CardSettlement setId_p1(String id_p1) {
        this.id_p1 = id_p1;
        return this;
    }

    public String getId_p2() {
        return id_p2;
    }

    public CardSettlement setId_p2(String id_p2) {
        this.id_p2 = id_p2;
        return this;
    }
}
