package com.jhscale.meter.protocol.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: CashSettlement
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2222:04
 */
@ApiModel("现金结算")
public class CashSettlement extends DeviceSettlement<CashSettlement> {

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "现金结算金额", name = "cash")
    private BigDecimal cash = BigDecimal.ZERO;

    public CashSettlement() {
        super(DeviceSettlementType.现金);
    }

    public CashSettlement(BigDecimal cash) {
        this();
        this.cash = cash;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public CashSettlement setCash(BigDecimal cash) {
        this.cash = cash;
        return this;
    }
}
