package com.jhscale.meter.protocol.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.em.PayType;
import com.jhscale.common.em.PayWay;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: JKYSettlement
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2222:09
 */
@ApiModel("聚合云支付结算")
public class CloudPaySettlement extends DeviceSettlement<CloudPaySettlement> {

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "云聚合支付金额", name = "cloudPay")
    private BigDecimal cloudPay = BigDecimal.ZERO;

    @ApiModelProperty(value = "交易渠道", name = "payWay")
    private PayWay payWay;

    @ApiModelProperty(value = "支付方式", name = "payWay")
    private PayType payType;

    @ApiModelProperty(value = "订单编号", name = "billId")
    private String billId;

    public CloudPaySettlement() {
        super(DeviceSettlementType.聚合支付);
    }

    public BigDecimal cloudPay() {
        return Objects.nonNull(this.cloudPay) ? this.cloudPay : BigDecimal.ZERO;
    }

    public BigDecimal getCloudPay() {
        return cloudPay;
    }

    public CloudPaySettlement setCloudPay(BigDecimal cloudPay) {
        this.cloudPay = cloudPay;
        return this;
    }

    public PayWay getPayWay() {
        return payWay;
    }

    public Integer payWay() {
        return (Objects.nonNull(this.payWay) ? this.payWay : PayWay.Aggregate_PAY).getType();
    }

    public String payWayDescription() {
        return (Objects.nonNull(this.payWay) ? this.payWay : PayWay.Aggregate_PAY).getDescription();
    }

    public CloudPaySettlement setPayWay(PayWay payWay) {
        this.payWay = payWay;
        return this;
    }

    public PayType getPayType() {
        return payType;
    }

    public Integer payType() {
        return (Objects.nonNull(this.payType) ? this.payType : PayType.UNKNOWN_PAY).getType();
    }

    public String payTypeDescription() {
        return (Objects.nonNull(this.payType) ? this.payType : PayType.UNKNOWN_PAY).getDescription();
    }

    public CloudPaySettlement setPayType(PayType payType) {
        this.payType = payType;
        return this;
    }

    public String getBillId() {
        return billId;
    }

    public CloudPaySettlement setBillId(String billId) {
        this.billId = billId;
        return this;
    }
}
