package com.jhscale.meter.protocol.trade;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: DeviceSettlement
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2218:37
 */
// JKY支付和卡付，因为共用VIP系统，不可同时存在
// Cloud支付只会使用一种方式，不会又使用支付宝和微信
// 除此之外，理论上所有支付可以混合使用。当除了现金外的支付金额小于总金额时，默认使用现金补足,在Total_Close时会自动计算。
// 计算规则为，如果所有支付方式加上现金大于总金额，则出现找零，如果不足，则默认现金补足金额。
@ApiModel("设备结算")
public class DeviceSettlement<T extends DeviceSettlement> extends JSONModel {

    @ApiModelProperty(value = "设备结算类型", name = "type")
    private DeviceSettlementType type;

    public DeviceSettlement() {
    }

    public DeviceSettlement(DeviceSettlementType type) {
        this.type = type;
    }

    public DeviceSettlementType getType() {
        return type;
    }

    public T setType(DeviceSettlementType type) {
        this.type = type;
        return (T) this;
    }
}
