package com.jhscale.meter.protocol.trade;

/**
 * @author lie_w
 * @title: DeviceSettlementType
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2218:38
 */
public enum DeviceSettlementType {

    现金(0, "现金"),
    吉卡云(1, "吉卡云会员"),
    卡付(2, "第三方卡付"),
    其他支付(3, "其他支付"),
    聚合支付(4, "聚合云支付");

    private int type;

    private String description;

    DeviceSettlementType(int type, String description) {
        this.type = type;
        this.description = description;
    }

    public static DeviceSettlementType type(int type) {
        for (DeviceSettlementType deviceSettlementType : DeviceSettlementType.values()) {
            if (deviceSettlementType.getType() == type) return deviceSettlementType;
        }
        return DeviceSettlementType.现金;
    }

    public int getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }
}
