package com.jhscale.meter.protocol.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: JKYSettlement
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2222:09
 */
@ApiModel("吉卡云结算")
public class JKYSettlement extends DeviceSettlement<JKYSettlement> {

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "吉卡云储值金额", name = "jkyPay")
    private BigDecimal jkyPay = BigDecimal.ZERO;
    @ApiModelProperty(value = "吉卡云赠送金额", name = "jkyPay_Gift")
    private BigDecimal jkyPay_Gift = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "积分(当前积分)", name = "point")
    private BigDecimal point = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "原余额（储值+赠送）", name = "balanceOld")
    private BigDecimal balanceOld = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "新余额（储值+赠送）", name = "balanceNew")
    private BigDecimal balanceNew = BigDecimal.ZERO;

    @ApiModelProperty(value = "账户（手机号存在手机号，手机号不存在卡号，卡号不存在套餐号）", name = "account")
    private String account;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "现金结算金额", name = "cash")
    private BigDecimal cash = BigDecimal.ZERO;

    public JKYSettlement() {
        super(DeviceSettlementType.吉卡云);
    }

    public BigDecimal jkyPay() {
        return Objects.nonNull(this.jkyPay) ? this.jkyPay : BigDecimal.ZERO;
    }

    public BigDecimal jkyPay_Gift() {
        return Objects.nonNull(this.jkyPay_Gift) ? this.jkyPay_Gift : BigDecimal.ZERO;
    }

    public BigDecimal point() {
        return Objects.nonNull(this.point) ? this.point : BigDecimal.ZERO;
    }

    public BigDecimal balanceOld() {
        return Objects.nonNull(this.balanceOld) ? this.balanceOld : BigDecimal.ZERO;
    }

    public BigDecimal balanceNew() {
        return Objects.nonNull(this.balanceNew) ? this.balanceNew : BigDecimal.ZERO;
    }

    public JKYSettlement addBalanceOld(BigDecimal balanceOld, BigDecimal balanceGiveOld) {
        if (this.balanceOld == null) this.balanceOld = BigDecimal.ZERO;
        if (balanceOld != null) this.balanceOld = this.balanceOld.add(balanceOld);
        if (balanceGiveOld != null) this.balanceOld = this.balanceOld.add(balanceGiveOld);
        return this;
    }

    public JKYSettlement addBalanceNew(BigDecimal balanceNew, BigDecimal balanceGiveNew) {
        if (this.balanceNew == null) this.balanceNew = BigDecimal.ZERO;
        if (balanceNew != null) this.balanceNew = this.balanceNew.add(balanceNew);
        if (balanceGiveNew != null) this.balanceNew = this.balanceNew.add(balanceGiveNew);
        return this;
    }

    public BigDecimal getJkyPay() {
        return jkyPay;
    }

    public JKYSettlement setJkyPay(BigDecimal jkyPay) {
        this.jkyPay = jkyPay;
        return this;
    }

    public BigDecimal getJkyPay_Gift() {
        return jkyPay_Gift;
    }

    public JKYSettlement setJkyPay_Gift(BigDecimal jkyPay_Gift) {
        this.jkyPay_Gift = jkyPay_Gift;
        return this;
    }

    public BigDecimal getPoint() {
        return point;
    }

    public JKYSettlement setPoint(BigDecimal point) {
        this.point = point;
        return this;
    }

    public BigDecimal getBalanceOld() {
        return balanceOld;
    }

    public JKYSettlement setBalanceOld(BigDecimal balanceOld) {
        this.balanceOld = balanceOld;
        return this;
    }

    public BigDecimal getBalanceNew() {
        return balanceNew;
    }

    public JKYSettlement setBalanceNew(BigDecimal balanceNew) {
        this.balanceNew = balanceNew;
        return this;
    }

    public String getAccount() {
        return account;
    }

    public JKYSettlement setAccount(String account) {
        this.account = account;
        return this;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public JKYSettlement setCash(BigDecimal cash) {
        this.cash = cash;
        return this;
    }
}
