package com.jhscale.meter.protocol.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: JKYSettlement
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2222:09
 */
@ApiModel("其他支付结算")
public class OtherPaySettlement extends DeviceSettlement<OtherPaySettlement> {

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "其他支付1", name = "other1")
    private BigDecimal other1 = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "其他支付2", name = "other2")
    private BigDecimal other2 = BigDecimal.ZERO;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "其他支付3", name = "other3")
    private BigDecimal other3 = BigDecimal.ZERO;

    public OtherPaySettlement() {
        super(DeviceSettlementType.其他支付);
    }

    public BigDecimal other1() {
        return Objects.nonNull(this.other1) ? this.other1 : BigDecimal.ZERO;
    }

    public BigDecimal other2() {
        return Objects.nonNull(this.other2) ? this.other2 : BigDecimal.ZERO;
    }

    public BigDecimal other3() {
        return Objects.nonNull(this.other3) ? this.other3 : BigDecimal.ZERO;
    }

    public BigDecimal getOther1() {
        return other1;
    }

    public OtherPaySettlement setOther1(BigDecimal other1) {
        this.other1 = other1;
        return this;
    }

    public BigDecimal getOther2() {
        return other2;
    }

    public OtherPaySettlement setOther2(BigDecimal other2) {
        this.other2 = other2;
        return this;
    }

    public BigDecimal getOther3() {
        return other3;
    }

    public OtherPaySettlement setOther3(BigDecimal other3) {
        this.other3 = other3;
        return this;
    }
}
