package com.jhscale.meter.seal.cmd;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.seal.em.SealACK;
import com.jhscale.meter.seal.em.SealCMD;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.SealRequest;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: ObtainStatusRequest
 * @description: TODO
 * @date 2024/9/5 17:53
 */
public class BLEInitRequest extends SealRequest<BLEInitRequest, BLEInitResponse> {

    // 铅封UID
    private String uid;

    // 模块数量
    private int size;

    // 随机字符
    private String r1;

    // 加密字符
    private String r2;

    public BLEInitRequest(Offset offset) {
        super(offset, SealCommand.蓝牙初始化, new SealSign(SealCMD.命令包, SealACK.命令包));
    }

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        byte[] uidb = ByteUtils.fromHexString(this.uid);
        byte[] r1b = ByteUtils.fromHexString(this.r1);
        byte[] r2b = new byte[4];
        r2b[0] = (byte) (((r1b[0] + uidb[0]) + 0x01) & 0xFF);
        r2b[1] = (byte) (((r1b[1] - uidb[1]) + 0x10) & 0xFF);
        r2b[2] = (byte) (((r1b[2] | uidb[2]) + 0xA5) & 0xFF);
        r2b[3] = (byte) (((r1b[3] & uidb[3]) + 0x5A) & 0xFF);
        this.r2 = ByteUtils.toHexString(r2b);
        this.source_inner
                .append(ByteUtils.int2Hex(this.size))
                .append(this.r1)
                .append(this.r2);
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getR1() {
        return r1;
    }

    public void setR1(String r1) {
        this.r1 = r1;
    }

    public String getR2() {
        return r2;
    }
}
