package com.jhscale.meter.seal.cmd;

import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MQTTUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: HandShakeRequest
 * @description: TODO
 * @date 2024/9/5 12:57
 */
public class BLEObtainStatusResponse extends SealResponse {

    // INIT:  1-模块未初始化，0-工作正常
    // RST： 1-模块发生掉电，0-工作正常
    // H1-3：1-发生过打开，0-工作正常
    // KEY1-3：1-当前仍打开，0-工作正常
    // UID：12字节，模块唯一码
    // SUID：秤体唯一码
    private String status;

    // 12字节，模块唯一码
    private String uid;

    // 12字节，模块唯一码
    private String suid;

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        this.status = MQTTUtils.hex2Bit(this.source_inner.substring(2, 4));
        this.uid = this.source_inner.substring(4, 28);
        int length = ByteUtils.hex2Ten(this.source_inner.substring(28, 30)) * 2;
        this.suid = ByteUtils.hex2Ascii(this.source_inner.substring(30, 30 + length));
    }

    public String getStatus() {
        return status;
    }

    public String getUid() {
        return uid;
    }

    public String getSuid() {
        return suid;
    }
}
