package com.jhscale.meter.seal.cmd;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import com.jhscale.meter.seal.em.SealACK;
import com.jhscale.meter.seal.em.SealCMD;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.SealRequest;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: ObtainStatusRequest
 * @description: TODO
 * @date 2024/9/5 17:53
 */
public class BLEResetRequest extends SealRequest<BLEResetRequest, BLEResetResponse> {

    // 铅封UID
    private String uid;

    // 随机字符
    private String r1;

    // 加密字符
    private String r3;

    public BLEResetRequest(Offset offset) {
        super(offset, SealCommand.蓝牙铅封复位, new SealSign(SealCMD.命令包, SealACK.命令包));
    }

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        byte[] uidb = ByteUtils.fromHexString(this.uid);
        byte[] r1b = ByteUtils.fromHexString(this.r1);
        byte[] r3b = new byte[4];
        r3b[0] = (byte) (((r1b[0] | uidb[4]) + 0xA5) & 0xFF);
        r3b[1] = (byte) (((r1b[1] & uidb[5]) + 0x5A) & 0xFF);
        r3b[2] = (byte) (((r1b[2] + uidb[6]) + 0x11) & 0xFF);
        r3b[3] = (byte) (((r1b[3] - uidb[7]) + 0x33) & 0xFF);
        this.r3 = ByteUtils.toHexString(r3b);
        this.source_inner.append(this.r3)
                .append(RandomUtils.getRandomHex(3));
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getR1() {
        return r1;
    }

    public void setR1(String r1) {
        this.r1 = r1;
    }

    public String getR3() {
        return r3;
    }
}
