package com.jhscale.meter.seal.cmd;

import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: HandShakeRequest
 * @description: TODO
 * @date 2024/9/5 12:57
 */
public class BLEResetResponse extends SealResponse {

    // Status（1字节）
    // 0- 复位失败，可能仍有开关打开。
    // 1- 成功
    private int result;

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        this.result = ByteUtils.hex2Ten(this.source_inner.substring(2, 4));
    }

    /**
     * @description: 蓝牙打开成功
     * @date: 2024-09-05 21:01:27
     **/
    public boolean resetSuccess() {
        return this.result == 1;
    }

    public int getResult() {
        return result;
    }

}
