package com.jhscale.meter.seal.cmd;

import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: HandShakeRequest
 * @description: TODO
 * @date 2024/9/5 12:57
 */
public class HandShakeResponse extends SealResponse {

    // OFFSET1：命令数据编码偏移量
    private String offset1;

    // OFFSET2：应答包数据编码偏移量
    private String offset2;

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        this.offset1 = this.source_inner.substring(0, 2);
        this.offset2 = this.source_inner.substring(2, 4);
    }

    public String getOffset1() {
        return offset1;
    }

    public String getOffset2() {
        return offset2;
    }

    public int offset1() {
        return ByteUtils.hex2Ten(this.offset1);
    }

    public int offset2() {
        return ByteUtils.hex2Ten(this.offset2);
    }
}
