package com.jhscale.meter.seal.cmd;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import com.jhscale.meter.seal.em.SealACK;
import com.jhscale.meter.seal.em.SealCMD;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.SealRequest;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: OpenBleRequest
 * @description: TODO
 * @date 2024/9/5 20:51
 */
public class OpenBLERequest extends SealRequest<OpenBLERequest, OpenBLEResponse> {

    private String unique;

    public OpenBLERequest(Offset offset) {
        super(offset, SealCommand.打开蓝牙, new SealSign(SealCMD.命令包, SealACK.命令包));
    }

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        String hex = ByteUtils.ascii2Hex(this.unique);
        int length = hex.length() / 2;
        String lengthStr = ByteUtils.int2Hex(length);
        this.source_inner
                .append(lengthStr)
                .append(hex)
                .append(RandomUtils.getRandomHex(31 - length));
    }

    public String getUnique() {
        return unique;
    }

    public OpenBLERequest setUnique(String unique) {
        this.unique = unique;
        return this;
    }
}
