package com.jhscale.meter.seal.cmd;

import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: HandShakeRequest
 * @description: TODO
 * @date 2024/9/5 12:57
 */
public class OpenBLEResponse extends SealResponse {

    // STATUS：1字节
    // 0： 打开蓝牙失败
    // 1： 打开蓝牙成功
    // 2： 蓝牙通讯超时
    // 3： 蓝牙通讯完成
    // 4： 硬件错误
    private int result;

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {
        this.result = ByteUtils.hex2Ten(this.source_inner.substring(2, 4));
    }

    /**
     * @description: 蓝牙打开成功
     * @date: 2024-09-05 21:01:27
     **/
    public boolean openSuccess() {
        return this.result == 1;
    }

    /**
     * @description: 业务通讯完成
     * @date: 2024-09-05 21:01:16
     **/
    public boolean actionSuccess() {
        return this.result == 3;
    }

    public int getResult() {
        return result;
    }

}
