package com.jhscale.meter.seal.em;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealACK
 * @description: TODO
 * @date 2024/9/5 15:49
 */
public enum SealACK {

    命令包(0, "发给模块的命令包"),
    应答包(1, "模块发出的应答包");

    private final int ack;

    private final String description;

    SealACK(int ack, String description) {
        this.ack = ack;
        this.description = description;
    }

    public static SealACK ack(int cmd) {
        for (SealACK value : SealACK.values()) {
            if (value.ack == cmd) return value;
        }
        return null;
    }

    public static SealACK ack(char cmd) {
        return ack(Integer.parseInt(String.valueOf(cmd)));
    }

    public int getAck() {
        return ack;
    }

    public String getDescription() {
        return description;
    }
}
