package com.jhscale.meter.seal.em;

import com.jhscale.meter.seal.cmd.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealCommand
 * @description: TODO
 * @date 2024/9/5 18:42
 */
public enum SealCommand {
    协议握手("46", HandShakeRequest.class, HandShakeResponse.class),
    读取状态(1, "01", ObtainStatusRequest.class, ObtainStatusResponse.class),
    打开蓝牙(2, "02", OpenBLERequest.class, OpenBLEResponse.class),
    蓝牙读取状态(3, "03", BLEObtainStatusRequest.class, BLEObtainStatusResponse.class),
    蓝牙铅封复位(4, "04", BLEResetRequest.class, BLEResetResponse.class),
    蓝牙初始化(5, "05", BLEInitRequest.class, BLEInitResponse.class),
    关闭蓝牙(6, "06", CloseBLERequest.class, CloseBLEResponse.class),
    ;

    private Integer no;

    private String command;

    private String sign;

    private final Class requestClass;

    private final Class responseClass;

    SealCommand(String sign, Class requestClass, Class responseClass) {
        this.sign = sign;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    SealCommand(Integer no, String command, Class requestClass, Class responseClass) {
        this.no = no;
        this.command = command;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static SealCommand no(Integer no) {
        if (Objects.nonNull(no)) {
            for (SealCommand value : SealCommand.values()) {
                if (Objects.nonNull(value.no) && value.no.equals(no)) return value;
            }
        }
        return null;
    }

    public static SealCommand hex(String command, String sign) {
        if (StringUtils.isNotBlank(command) && StringUtils.isNotBlank(sign)) {
            for (SealCommand value : SealCommand.values()) {
                if (sign.equalsIgnoreCase(value.sign) || command.equalsIgnoreCase(value.command))
                    return value;
            }
        }
        return null;
    }

    public Integer getNo() {
        return no;
    }

    public String getCommand() {
        return StringUtils.isNotBlank(this.command) ? this.command : "";
    }

    public String getSign() {
        return sign;
    }

    public Class getRequestClass() {
        return requestClass;
    }

    public Class getResponseClass() {
        return responseClass;
    }
}
