package com.jhscale.meter.seal.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.model.base.JSONMeter;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;
import com.jhscale.meter.seal.utils.SealUtils;
import com.jhscale.meter.utils.Constant;

import java.lang.reflect.ParameterizedType;

/**
 * @author lie_w
 * @title: ADPackAssembly
 * @projectName meter-jar
 * @description: (组装请求)
 * @date 2021/6/109:36
 */
public abstract class SealRequest<T extends SealRequest, U extends SealResponse> implements JSONMeter {

    // 偏移量
    protected Offset offset;

    // 指令类型
    protected SealCommand command;

    // 标志位
    protected SealSign sign;

    // 指令缓冲区
    protected StringBuilder source_inner;

    // 指令缓冲区
    protected String cryption_inner;

    // 原始数据包
    protected StringBuilder builder;

    public SealRequest() {
    }

    public SealRequest(Offset offset) {
        this.offset = offset;
    }

    public SealRequest(Offset offset, SealCommand command, SealSign sign) {
        this(offset);
        this.command = command;
        this.sign = sign;
    }

    /**
     * @description: 协议执行器
     **/
    public T execute() throws MeterException {
        this.source_inner = new StringBuilder(this.command.getCommand());

        // 内容体组装
        this.inner_execute();

        this.cryption_inner = SealUtils.encode(this.source_inner.toString(), this.offset);

        String sign = this.sign.appendLength(this.cryption_inner)
                .sign().getBinary();

        String crc = SealUtils.verify(sign + this.cryption_inner);

        this.builder = new StringBuilder()
                .append(Constant.TOP)
                .append(sign)
                .append(this.cryption_inner)
                .append(crc)
                .append(Constant.END);
        return (T) this;
    }

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    protected abstract void inner_execute();

    /**
     * @description: 完整数据包
     * @date: 2024-09-06 14:21:16
     **/
    public String over() {
        return this.builder.toString();
    }

    public StringBuilder getSource_inner() {
        return source_inner;
    }

    public String getCryption_inner() {
        return cryption_inner;
    }

    /**
     * @description: 返回值Interface 定义泛型类型 类型
     **/
    public <U extends SealResponse> Class<U> getResponseClass() {
        ParameterizedType parameterizedType = (ParameterizedType) this.getClass().getGenericSuperclass();
        return (Class<U>) parameterizedType.getActualTypeArguments()[1];
    }
}
