package com.jhscale.meter.seal.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;
import com.jhscale.meter.seal.utils.SealUtils;

import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealResponse
 * @description: TODO
 * @date 2024/9/5 15:11
 */
public class SealResponse<T extends SealRequest, U extends SealResponse> extends SealRequest {

    /**
     * @description: 请求信息
     **/
    private T request;

    public SealResponse() {
    }

    public SealResponse(Offset offset, String content) {
        super(offset);
        this.builder = new StringBuilder(content);
    }

    public SealResponse(Offset offset, T request, String content) {
        this(offset, content);
        this.request = request;
    }

    /**
     * @description: 协议执行器
     **/
    @Override
    public U execute() throws MeterException {
        this.sign = new SealSign(this.builder.substring(2, 4));
        int inner_length = this.sign.inner_length();

        String crc_content = this.builder.substring(2, 4 + inner_length);
        String crc_count = SealUtils.verify(crc_content);
        String crc_data = this.builder.substring(this.builder.length() - 4, this.builder.length() - 2);
        if (!crc_count.equalsIgnoreCase(crc_data)) {
            System.err.printf("crc_content:[%s] crc_count:[%s] crc_data[%s]%n", crc_content, crc_count, crc_data);
            throw new MeterException(MeterStateEnum.SL_CRC检查错误);
        }

        this.cryption_inner = crc_content.substring(2);
        this.source_inner = new StringBuilder().append(SealUtils.decode(this.cryption_inner, this.offset));

        String command_hex = this.source_inner.substring(0, 2);
        this.command = SealCommand.hex(command_hex, this.sign.getBinary());

        U u = (U) this;

        try {
            Class<U> clazz = Objects.nonNull(this.request) ? this.request.getResponseClass() : this.command.getResponseClass();
            u = clazz.newInstance();
            u.command = this.command;
            u.sign = this.sign;
            u.builder = this.builder;
            u.source_inner = this.source_inner;
        } catch (Exception e) {
            e.printStackTrace();
        }
        u.inner_execute();
        return u;
    }

    /**
     * @description: 内容体填充
     * @date: 2024-09-05 15:20:21
     **/
    @Override
    protected void inner_execute() {

    }

    public T getRequest() {
        return request;
    }

    public void setRequest(T request) {
        this.request = request;
    }
}
