package com.jhscale.meter.seal.entity.inner;

import com.jhscale.meter.model.base.JSONMeter;
import com.jhscale.meter.seal.em.SealACK;
import com.jhscale.meter.seal.em.SealCMD;
import com.jhscale.meter.seal.utils.SealUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MQTTUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealSign
 * @description: TODO
 * @date 2024/9/5 15:46
 */
public class SealSign implements JSONMeter {

    // 标志值
    private String binary;

    private SealCMD cmd;

    private SealACK ack;

    private int length;

    public SealSign() {
    }

    public SealSign(SealCMD cmd, SealACK ack) {
        this.cmd = cmd;
        this.ack = ack;
    }

    public SealSign(String sign) {
        this.binary = sign;
        String binary = MQTTUtils.hex2Bit(sign);
        this.cmd = SealCMD.cmd(binary.charAt(0));
        this.ack = SealACK.ack(binary.charAt(1));
        this.length = Integer.parseInt(binary.substring(2), 2);
    }

    /**
     * @description: 添加填充长度
     * @date: 2024-09-05 15:58:22
     */
    public SealSign appendLength(String cryption_inner) {
        this.length = cryption_inner.length() / 2;
        return this;
    }

    /**
     * @description: 获取标志值
     * @date: 2024-09-05 15:59:20
     **/
    public SealSign sign() {
        String binary = String.format("%s%s%s", this.cmd.getCmd(), this.ack.getAck(), SealUtils.length(this.length + 4));
        this.binary = ByteUtils.dataFormat(binary);
        return this;
    }

    /**
     * @description: 内包数据长度
     * @date: 2024-09-05 17:01:28
     */
    public int inner_length() {
        return (this.length - 4) * 2;
    }

    /**
     * @description: 数据包长度
     * @date: 2024-09-06 09:46:32
     **/
    public int length() {
        return this.length * 2;
    }

    public String getBinary() {
        return binary;
    }

    public void setBinary(String binary) {
        this.binary = binary;
    }

    public SealCMD getCmd() {
        return cmd;
    }

    public void setCmd(SealCMD cmd) {
        this.cmd = cmd;
    }

    public SealACK getAck() {
        return ack;
    }

    public void setAck(SealACK ack) {
        this.ack = ack;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}
