package com.jhscale.meter.seal.utils;

import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.utils.ByteUtils;

import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealUtils
 * @description: TODO
 * @date 2024/9/5 13:39
 */
public class SealUtils {

    public static final int[] codeArr = {
            0xE0, 0x12, 0xC5, 0xB8, 0x2A, 0x0E, 0x23, 0x25, 0x00, 0x58, 0xD6, 0x4C, 0x8F, 0xD1, 0x65, 0x52,
            0x6A, 0xE1, 0xCC, 0xD4, 0x10, 0x74, 0x72, 0x9A, 0x14, 0x6D, 0x4D, 0x7C, 0x4F, 0xED, 0xC8, 0xEF,
            0xC7, 0x2C, 0xF1, 0x36, 0x78, 0x2D, 0x96, 0x67, 0x30, 0x70, 0xE9, 0x9C, 0xCE, 0xB9, 0x90, 0xC6,
            0x04, 0x50, 0x61, 0x4B, 0xA1, 0x8A, 0x45, 0x07, 0x9D, 0x5D, 0x9E, 0x99, 0xF2, 0xE4, 0x93, 0x81,
            0xDA, 0x5B, 0xE6, 0x84, 0x49, 0x02, 0xA8, 0x17, 0xA0, 0xB2, 0xA2, 0xDE, 0xD0, 0x11, 0xF4, 0xDD,
            0x8C, 0xFB, 0xFA, 0xE8, 0x87, 0xA9, 0x69, 0x37, 0xC9, 0x98, 0x91, 0x6C, 0x3D, 0xCF, 0xF3, 0xAC,
            0xA5, 0x08, 0xEC, 0x33, 0xC1, 0x0F, 0x57, 0x39, 0x20, 0xD3, 0x1B, 0x80, 0x47, 0x8B, 0x76, 0x1F,
            0x59, 0x66, 0xB7, 0xB3, 0x29, 0xEE, 0xA3, 0x51, 0x42, 0x18, 0x85, 0xFE, 0x0A, 0x82, 0xF7, 0x5E,
            0x28, 0x89, 0x7D, 0x15, 0x3F, 0xB6, 0x9F, 0xE3, 0xEB, 0xDB, 0x5A, 0x7B, 0x7F, 0x94, 0x06, 0xBF,
            0x13, 0xF5, 0x21, 0x79, 0x35, 0x9B, 0x92, 0x8E, 0xCA, 0x09, 0x32, 0xF9, 0x2E, 0x0C, 0x1C, 0xD7,
            0x3A, 0x38, 0x4E, 0xB4, 0xD5, 0xBA, 0x77, 0x40, 0xE2, 0xE5, 0x01, 0xFD, 0x86, 0x3B, 0xDF, 0xF6,
            0x68, 0x54, 0x62, 0x46, 0xA6, 0x1E, 0xFC, 0x5F, 0xD9, 0xBC, 0xC0, 0x7A, 0x55, 0x5C, 0x6E, 0x0B,
            0x88, 0x7E, 0xAA, 0xB1, 0xF8, 0x95, 0x71, 0xBE, 0x6F, 0xB0, 0xAD, 0x31, 0xA7, 0xD2, 0x44, 0x34,
            0xDC, 0x0D, 0x73, 0xBD, 0xB5, 0xAF, 0x3C, 0x19, 0x56, 0x22, 0xC2, 0x6B, 0xCD, 0x8D, 0x64, 0xFF,
            0x41, 0x05, 0xF0, 0x24, 0xAE, 0xEA, 0x1D, 0x2B, 0x4A, 0x60, 0x75, 0x2F, 0xBB, 0xC3, 0xD8, 0x1A,
            0xCB, 0x27, 0x03, 0x43, 0x3E, 0x63, 0x83, 0x53, 0x26, 0x16, 0x48, 0x97, 0xA4, 0xAB, 0xC4, 0xE7,

    };

    public static final int[] decodeArr = {
            0x08, 0xAA, 0x45, 0xF2, 0x30, 0xE1, 0x8E, 0x37, 0x61, 0x99, 0x7C, 0xBF, 0x9D, 0xD1, 0x05, 0x65,
            0x14, 0x4D, 0x01, 0x90, 0x18, 0x83, 0xF9, 0x47, 0x79, 0xD7, 0xEF, 0x6A, 0x9E, 0xE6, 0xB5, 0x6F,
            0x68, 0x92, 0xD9, 0x06, 0xE3, 0x07, 0xF8, 0xF1, 0x80, 0x74, 0x04, 0xE7, 0x21, 0x25, 0x9C, 0xEB,
            0x28, 0xCB, 0x9A, 0x63, 0xCF, 0x94, 0x23, 0x57, 0xA1, 0x67, 0xA0, 0xAD, 0xD6, 0x5C, 0xF4, 0x84,
            0xA7, 0xE0, 0x78, 0xF3, 0xCE, 0x36, 0xB3, 0x6C, 0xFA, 0x44, 0xE8, 0x33, 0x0B, 0x1A, 0xA2, 0x1C,
            0x31, 0x77, 0x0F, 0xF7, 0xB1, 0xBC, 0xD8, 0x66, 0x09, 0x70, 0x8A, 0x41, 0xBD, 0x39, 0x7F, 0xB7,
            0xE9, 0x32, 0xB2, 0xF5, 0xDE, 0x0E, 0x71, 0x27, 0xB0, 0x56, 0x10, 0xDB, 0x5B, 0x19, 0xBE, 0xC8,
            0x29, 0xC6, 0x16, 0xD2, 0x15, 0xEA, 0x6E, 0xA6, 0x24, 0x93, 0xBB, 0x8B, 0x1B, 0x82, 0xC1, 0x8C,
            0x6B, 0x3F, 0x7D, 0xF6, 0x43, 0x7A, 0xAC, 0x54, 0xC0, 0x81, 0x35, 0x6D, 0x50, 0xDD, 0x97, 0x0C,
            0x2E, 0x5A, 0x96, 0x3E, 0x8D, 0xC5, 0x26, 0xFB, 0x59, 0x3B, 0x17, 0x95, 0x2B, 0x38, 0x3A, 0x86,
            0x48, 0x34, 0x4A, 0x76, 0xFC, 0x60, 0xB4, 0xCC, 0x46, 0x55, 0xC2, 0xFD, 0x5F, 0xCA, 0xE4, 0xD5,
            0xC9, 0xC3, 0x49, 0x73, 0xA3, 0xD4, 0x85, 0x72, 0x03, 0x2D, 0xA5, 0xEC, 0xB9, 0xD3, 0xC7, 0x8F,
            0xBA, 0x64, 0xDA, 0xED, 0xFE, 0x02, 0x2F, 0x20, 0x1E, 0x58, 0x98, 0xF0, 0x12, 0xDC, 0x2C, 0x5D,
            0x4C, 0x0D, 0xCD, 0x69, 0x13, 0xA4, 0x0A, 0x9F, 0xEE, 0xB8, 0x40, 0x89, 0xD0, 0x4F, 0x4B, 0xAE,
            0x00, 0x11, 0xA8, 0x87, 0x3D, 0xA9, 0x42, 0xFF, 0x53, 0x2A, 0xE5, 0x88, 0x62, 0x1D, 0x75, 0x1F,
            0xE2, 0x22, 0x3C, 0x5E, 0x4E, 0x91, 0xAF, 0x7E, 0xC4, 0x9B, 0x52, 0x51, 0xB6, 0xAB, 0x7B, 0xDF,
    };

    /**
     * @description: 计算标志位长度
     * @date: 2024-09-05 14:24:52
     **/
    public static String length(int innerLength) {
        return ByteUtils.ten2two(innerLength, 6);
    }

    /**
     * @description: 校验数值
     * @date: 2024-09-05 14:25:11
     */
    public static String verify(String content) {
        int val = 0;
        for (int i = 0; i < content.length(); i = i + 2) {
            val += ByteUtils.hex2Ten(content.substring(i, i + 2));
        }
        val = 0xff - val % 0x0100;
        return ByteUtils.int2Hex(val);
    }

    private static Integer nid;

    /**
     * @description: NID
     **/
    public synchronized static int nid() {
        if (nid == null) {
            nid = (int) (Math.random() * 255);
        } else {
            nid = nid + 1;
        }
        return nid;
    }

    /**
     * @description: 编码
     * @date: 2024-09-06 14:03:56
     **/
    public static String encode(String command, Offset offset) {
        if (Objects.nonNull(offset)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < command.length(); i = i + 2) {
                int c = ByteUtils.hex2Ten(command.substring(i, i + 2));
                int hex = codeArr[(c + offset.getS1()) % 0x0100];
                // System.out.println(c + "-" + offset.getS1() + "-" + (c + offset.getS1()) + "-" + ((c + offset.getS1()) % 0x01FF));
                builder.append(ByteUtils.int2Hex(hex));
            }
            command = builder.toString();
        }
        return command;
    }

    /**
     * @description: 解码
     * @date: 2024-09-06 14:01:24
     **/
    public static String decode(String command, Offset offset) {
        if (Objects.nonNull(offset)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < command.length(); i = i + 2) {
                int c = ByteUtils.hex2Ten(command.substring(i, i + 2));
                int hex = (decodeArr[c] - offset.getS2()) % 0x0100;
                builder.append(ByteUtils.int2Hex(hex));
            }
            command = builder.toString();
        }
        return command;
    }
}
