package com.jhscale.meter.tool.barcode.em;

import static com.jhscale.meter.protocol.constant.TMS.*;

/**
 * @author lie_w
 * @title: Commodity
 * @projectName meter-jar
 * @description: 商品类型
 * @date 2022/8/52:49
 */
public enum Commodity {

    普通商品(-1, SP_Sale_Acc_C_Key),
    普通条码(0, SP_Sale_Acc_C_Scanner),
    收银条码(1, SP_Sale_Acc_N_Barcode);

    // 类型
    @Deprecated
    private int type;

    private int tms;

    Commodity(int type, int tms) {
        this.type = type;
        this.tms = tms;
    }

    @Deprecated
    public static Commodity type(int type) {
        for (Commodity commodity : Commodity.values()) {
            if (commodity.getType() == type) return commodity;
        }
        return null;
    }

    public static Commodity tms(int tms) {
        for (Commodity commodity : Commodity.values()) {
            if (commodity.getTms() == tms) return commodity;
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public int getTms() {
        return tms;
    }
}
