package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.ysscale.UnitEnum;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: BarCodeInfo
 * @projectName meter-jar
 * @description: 条码信息
 * @date 2022/8/51:14
 */
public class BarCodeInfo extends JSONModel {

    // 第二部分
    private int part2;

    // 货号
    private int number;

    // PLU编号（规格）
    private int pluNo;

    // 常量
    private String constant;

    // 数重量
    private String val;

    // 数量
    private BigDecimal amount;

    // 重量
    private BigDecimal weight;

    // 单价
    private BigDecimal price;

    // 小计|总计
    private BigDecimal total;

    /**
     * @description: 标准单位 计件 计重 EAN13 需要同时标准 单价
     **/
    public BarCodeInfo labelUnitAndPrice(Rule rule, int unit, BigDecimal price) {
        this.price = price.setScale(rule.getMoney(), rule.getRound());
        String val = String.valueOf(unit);
        if (Objects.nonNull(this.total)) {
            if (val.equalsIgnoreCase(UnitEnum.计重.getVal())) {
                this.weight = this.total.divide(price, rule.getWeight(), rule.getRound());
            } else if (val.equalsIgnoreCase(UnitEnum.计件.getVal())) {
                this.amount = this.total.divide(price, rule.getAmount(), rule.getRound());
            }
        } else if (StringUtils.isNotBlank(this.val)) {
            if (val.equalsIgnoreCase(UnitEnum.计重.getVal())) {
                this.weight = rule.convertWeight(this.val);
                this.total = this.price.multiply(this.weight).setScale(rule.getMoney(), rule.getRound());
            } else if (val.equalsIgnoreCase(UnitEnum.计件.getVal())) {
                this.amount = rule.convertAmount(this.val);
                this.total = this.price.multiply(this.amount).setScale(rule.getMoney(), rule.getRound());
            }
        }
        return this;
    }

    /**
     * @description: 标准单位 计件 计重 EAN18
     **/
    public BarCodeInfo labelUnit(Rule rule, int unit) {
        String val = String.valueOf(unit);
        if (val.equalsIgnoreCase(UnitEnum.计重.getVal())) {
            this.weight = rule.convertWeight(this.val);
            this.price = this.total.divide(this.weight, rule.getMoney(), rule.getRound());
        } else if (val.equalsIgnoreCase(UnitEnum.计件.getVal())) {
            this.amount = rule.convertAmount(this.val);
            this.price = this.total.divide(this.amount, rule.getMoney(), rule.getRound());
        }
        return this;
    }


    /**
     * @description: 获取数重量
     **/
    public BigDecimal weightOrAmount() {
        return Objects.nonNull(this.weight) ? this.weight : this.amount;
    }

    /**
     * @description: PLU 货号 编号 常量
     **/
    public PLUNumberNoConstant pluNumberNoConstant() {
        return new PLUNumberNoConstant(this.number, this.pluNo, this.constant);
    }

    public int getPart2() {
        return part2;
    }

    public void setPart2(int part2) {
        this.part2 = part2;
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getPluNo() {
        return pluNo;
    }

    public void setPluNo(int pluNo) {
        this.pluNo = pluNo;
    }

    public String getConstant() {
        return constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTotal() {
        return total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }
}
